/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.proxy.repository;

import com.buschmais.xo.api.metadata.method.MethodMetadata;
import com.buschmais.xo.api.metadata.method.ResultOfMethodMetadata;
import com.buschmais.xo.api.metadata.reflection.AnnotatedMethod;
import com.buschmais.xo.api.metadata.type.RepositoryTypeMetadata;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.impl.proxy.AbstractProxyMethodService;
import com.buschmais.xo.impl.proxy.common.DelegateMethod;
import com.buschmais.xo.impl.proxy.repository.composite.ResultOfMethod;
import com.buschmais.xo.impl.proxy.repository.object.EqualsMethod;
import com.buschmais.xo.impl.proxy.repository.object.HashCodeMethod;
import com.buschmais.xo.impl.proxy.repository.object.ToStringMethod;
import java.lang.reflect.Method;

public class RepositoryProxyMethodService<T, Entity, Relation>
extends AbstractProxyMethodService<T> {
    public RepositoryProxyMethodService(T datastoreRepository, Class<?> repositoryType) {
        for (Method method : repositoryType.getMethods()) {
            if (!method.getDeclaringClass().isAssignableFrom(datastoreRepository.getClass())) continue;
            DelegateMethod<T> proxyMethod = new DelegateMethod<T>(datastoreRepository, method);
            this.addProxyMethod(proxyMethod, method);
        }
        this.addMethod(new HashCodeMethod(), Object.class, "hashCode", new Class[0]);
        this.addMethod(new EqualsMethod(), Object.class, "equals", Object.class);
        this.addMethod(new ToStringMethod(), Object.class, "toString", new Class[0]);
    }

    public RepositoryProxyMethodService(T datastoreRepository, RepositoryTypeMetadata repositoryMetadata, SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext) {
        this(datastoreRepository, (Class)repositoryMetadata.getAnnotatedType().getAnnotatedElement());
        for (MethodMetadata methodMetadata : repositoryMetadata.getProperties()) {
            AnnotatedMethod typeMethod = methodMetadata.getAnnotatedMethod();
            this.addUnsupportedOperationMethod(methodMetadata, typeMethod);
            this.addImplementedByMethod(methodMetadata, typeMethod);
            if (!(methodMetadata instanceof ResultOfMethodMetadata)) continue;
            ResultOfMethodMetadata resultOfMethodMetadata = (ResultOfMethodMetadata)methodMetadata;
            this.addProxyMethod(new ResultOfMethod(sessionContext, resultOfMethodMetadata), (Method)typeMethod.getAnnotatedElement());
        }
    }
}

