/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.CompositeObject;
import com.buschmais.xo.api.XOMigrator;
import com.buschmais.xo.api.metadata.MetadataProvider;
import com.buschmais.xo.api.metadata.type.CompositeTypeMetadata;
import com.buschmais.xo.api.metadata.type.DatastoreEntityMetadata;
import com.buschmais.xo.api.metadata.type.DatastoreRelationMetadata;
import com.buschmais.xo.api.metadata.type.EntityTypeMetadata;
import com.buschmais.xo.impl.AbstractInstanceManager;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.spi.datastore.DatastoreEntityManager;
import java.util.HashSet;
import java.util.Set;

public class XOMigratorImpl<T, EntityId, Entity, EntityMetadata extends DatastoreEntityMetadata<EntityDiscriminator>, EntityDiscriminator>
implements XOMigrator {
    private T instance;
    private MetadataProvider<EntityMetadata, EntityDiscriminator, ? extends DatastoreRelationMetadata<?>, ?> metadataProvider;
    private DatastoreEntityManager<EntityId, Entity, EntityMetadata, EntityDiscriminator, ?> datastoreEntityManager;
    private AbstractInstanceManager<EntityId, Entity> entityInstanceManager;

    XOMigratorImpl(T instance, SessionContext<EntityId, Entity, EntityMetadata, EntityDiscriminator, ?, ?, ?, ?, ?> sessionContext) {
        this.instance = instance;
        this.metadataProvider = sessionContext.getMetadataProvider();
        this.datastoreEntityManager = sessionContext.getDatastoreSession().getDatastoreEntityManager();
        this.entityInstanceManager = sessionContext.getEntityInstanceManager();
    }

    public CompositeObject add(Class<?> newType, Class<?> ... newTypes) {
        CompositeTypeMetadata<EntityTypeMetadata<EntityMetadata>> types = this.getDiscriminators(newType, newTypes);
        HashSet newDiscriminators = new HashSet(this.metadataProvider.getEntityDiscriminators(types));
        Entity entity = this.removeInstance(this.entityInstanceManager);
        Set entityDiscriminators = this.datastoreEntityManager.getEntityDiscriminators(entity);
        newDiscriminators.removeAll(entityDiscriminators);
        this.datastoreEntityManager.addDiscriminators(types, entity, newDiscriminators);
        return this.createInstance(entity);
    }

    public CompositeObject remove(Class<?> obsoleteType, Class<?> ... obsoleteTypes) {
        CompositeTypeMetadata<EntityTypeMetadata<EntityMetadata>> types = this.getDiscriminators(obsoleteType, obsoleteTypes);
        HashSet obsoleteDiscriminators = new HashSet(this.metadataProvider.getEntityDiscriminators(types));
        Entity entity = this.removeInstance(this.entityInstanceManager);
        Set entityDiscriminators = this.datastoreEntityManager.getEntityDiscriminators(entity);
        obsoleteDiscriminators.retainAll(entityDiscriminators);
        this.datastoreEntityManager.removeDiscriminators(types, entity, obsoleteDiscriminators);
        return this.createInstance(entity);
    }

    private CompositeTypeMetadata<EntityTypeMetadata<EntityMetadata>> getDiscriminators(Class<?> type, Class<?>[] types) {
        HashSet<EntityTypeMetadata> metadata = new HashSet<EntityTypeMetadata>();
        metadata.add(this.metadataProvider.getEntityMetadata(type));
        for (Class<?> currentType : types) {
            metadata.add(this.metadataProvider.getEntityMetadata(currentType));
        }
        return new CompositeTypeMetadata(metadata);
    }

    private Entity removeInstance(AbstractInstanceManager<EntityId, Entity> entityInstanceManager) {
        Entity entity = entityInstanceManager.getDatastoreType(this.instance);
        entityInstanceManager.removeInstance(this.instance);
        return entity;
    }

    private CompositeObject createInstance(Entity entity) {
        CompositeTypeMetadata<?> metadata = this.entityInstanceManager.getTypes(entity);
        this.instance = this.entityInstanceManager.createInstance(entity, metadata);
        return (CompositeObject)CompositeObject.class.cast(this.instance);
    }
}

