/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.impl.datastore;

import com.buschmais.xo.api.ResultIterable;
import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedLabel;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedNode;
import com.buschmais.xo.neo4j.spi.AbstractNeo4jRepository;
import com.buschmais.xo.neo4j.spi.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.spi.metadata.PropertyMetadata;
import com.buschmais.xo.spi.session.XOSession;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

public class EmbeddedNeo4jRepository
extends AbstractNeo4jRepository<EmbeddedLabel> {
    private final GraphDatabaseService graphDatabaseService;

    protected EmbeddedNeo4jRepository(GraphDatabaseService graphDatabaseService, XOSession<NodeMetadata<EmbeddedLabel>, EmbeddedLabel, ?, ?> xoSession) {
        super(xoSession);
        this.graphDatabaseService = graphDatabaseService;
    }

    protected <T> ResultIterable<T> find(EmbeddedLabel label, PropertyMetadata datastoreMetadata, Object datastoreValue) {
        String propertyName = datastoreMetadata.getName();
        final ResourceIterator iterator = this.graphDatabaseService.findNodes(label.getDelegate(), propertyName, datastoreValue);
        return this.xoSession.toResult((ResultIterator)new ResultIterator<EmbeddedNode>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public EmbeddedNode next() {
                return new EmbeddedNode((Node)iterator.next());
            }

            public void close() {
                iterator.close();
            }
        });
    }
}

