/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.impl.datastore;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.api.TypedNeo4jRepository;
import com.buschmais.xo.neo4j.api.annotation.Cypher;
import com.buschmais.xo.neo4j.embedded.api.EmbeddedNeo4jDatastoreSession;
import com.buschmais.xo.neo4j.embedded.impl.converter.EmbeddedParameterConverter;
import com.buschmais.xo.neo4j.embedded.impl.converter.EmbeddedValueConverter;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedCypherQuery;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedDatastoreTransaction;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedEntityManager;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedRelationManager;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedRepository;
import com.buschmais.xo.neo4j.embedded.impl.datastore.TypedEmbeddedRepository;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedLabel;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedNode;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedRelationship;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedRelationshipType;
import com.buschmais.xo.neo4j.spi.AbstractNeo4jDatastoreSession;
import com.buschmais.xo.neo4j.spi.helper.Converter;
import com.buschmais.xo.neo4j.spi.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.spi.metadata.PropertyMetadata;
import com.buschmais.xo.neo4j.spi.metadata.RelationshipMetadata;
import com.buschmais.xo.spi.datastore.DatastoreEntityManager;
import com.buschmais.xo.spi.datastore.DatastoreQuery;
import com.buschmais.xo.spi.datastore.DatastoreRelationManager;
import com.buschmais.xo.spi.datastore.DatastoreTransaction;
import com.buschmais.xo.spi.reflection.ClassHelper;
import com.buschmais.xo.spi.session.XOSession;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.neo4j.graphdb.GraphDatabaseService;

public class EmbeddedDatastoreSessionImpl
extends AbstractNeo4jDatastoreSession<EmbeddedNode, EmbeddedLabel, EmbeddedRelationship, EmbeddedRelationshipType>
implements EmbeddedNeo4jDatastoreSession {
    private final GraphDatabaseService graphDatabaseService;
    private final DatastoreTransaction datastoreTransaction;
    private final EmbeddedEntityManager entityManager;
    private final EmbeddedRelationManager relationManager;
    private final Converter parameterConverter;
    private final Converter valueConverter;

    public EmbeddedDatastoreSessionImpl(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
        this.entityManager = new EmbeddedEntityManager(graphDatabaseService);
        this.relationManager = new EmbeddedRelationManager(graphDatabaseService);
        this.parameterConverter = new Converter(Arrays.asList(new EmbeddedParameterConverter()));
        this.valueConverter = new Converter(Arrays.asList(new EmbeddedValueConverter()));
        this.datastoreTransaction = new EmbeddedDatastoreTransaction(graphDatabaseService);
    }

    public DatastoreTransaction getDatastoreTransaction() {
        return this.datastoreTransaction;
    }

    public DatastoreEntityManager<Long, EmbeddedNode, NodeMetadata<EmbeddedLabel>, EmbeddedLabel, PropertyMetadata> getDatastoreEntityManager() {
        return this.entityManager;
    }

    public DatastoreRelationManager<EmbeddedNode, Long, EmbeddedRelationship, RelationshipMetadata<EmbeddedRelationshipType>, EmbeddedRelationshipType, PropertyMetadata> getDatastoreRelationManager() {
        return this.relationManager;
    }

    public Class<? extends Annotation> getDefaultQueryLanguage() {
        return Cypher.class;
    }

    @Override
    public GraphDatabaseService getGraphDatabaseService() {
        return this.graphDatabaseService;
    }

    public <QL extends Annotation> DatastoreQuery<QL> createQuery(Class<QL> queryLanguage) {
        if (Cypher.class.equals(queryLanguage)) {
            return new EmbeddedCypherQuery(this);
        }
        throw new XOException("Unsupported query language: " + queryLanguage.getName());
    }

    public <R> R createRepository(XOSession xoSession, Class<R> type) {
        if (TypedNeo4jRepository.class.isAssignableFrom(type)) {
            Class typeParameter = ClassHelper.getTypeParameter(TypedNeo4jRepository.class, type);
            if (typeParameter == null) {
                throw new XOException("Cannot determine type parameter for " + type.getName());
            }
            return (R)((Object)new TypedEmbeddedRepository(typeParameter, this.graphDatabaseService, xoSession));
        }
        return (R)((Object)new EmbeddedRepository(this.graphDatabaseService, xoSession));
    }

    public void close() {
    }

    public Object convertParameter(Object value) {
        return this.parameterConverter.convert(value);
    }

    public Object convertValue(Object value) {
        return this.valueConverter.convert(value);
    }
}

