/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.impl.datastore;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.api.metadata.type.RelationTypeMetadata;
import com.buschmais.xo.neo4j.embedded.impl.datastore.AbstractEmbeddedPropertyManager;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedDirection;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedNode;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedRelationship;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedRelationshipType;
import com.buschmais.xo.neo4j.spi.metadata.PropertyMetadata;
import com.buschmais.xo.neo4j.spi.metadata.RelationshipMetadata;
import com.buschmais.xo.spi.datastore.DatastoreRelationManager;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;

public class EmbeddedRelationManager
extends AbstractEmbeddedPropertyManager<EmbeddedRelationship>
implements DatastoreRelationManager<EmbeddedNode, Long, EmbeddedRelationship, RelationshipMetadata<EmbeddedRelationshipType>, EmbeddedRelationshipType, PropertyMetadata> {
    private final GraphDatabaseService graphDatabaseService;

    public EmbeddedRelationManager(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    public boolean isRelation(Object o) {
        return EmbeddedRelationship.class.isAssignableFrom(o.getClass());
    }

    public EmbeddedRelationshipType getRelationDiscriminator(EmbeddedRelationship relationship) {
        return relationship.getType();
    }

    public EmbeddedRelationship createRelation(EmbeddedNode source, RelationTypeMetadata<RelationshipMetadata<EmbeddedRelationshipType>> metadata, RelationTypeMetadata.Direction direction, EmbeddedNode target, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> example) {
        EmbeddedRelationship relationship;
        EmbeddedRelationshipType relationshipType = (EmbeddedRelationshipType)((RelationshipMetadata)metadata.getDatastoreMetadata()).getDiscriminator();
        switch (direction) {
            case FROM: {
                relationship = source.createRelationshipTo(target, relationshipType);
                break;
            }
            case TO: {
                relationship = target.createRelationshipTo(source, relationshipType);
                break;
            }
            default: {
                throw new XOException("Unsupported direction " + direction);
            }
        }
        this.setProperties(relationship, example);
        return relationship;
    }

    public void deleteRelation(EmbeddedRelationship relationship) {
        relationship.delete();
    }

    public Long getRelationId(EmbeddedRelationship relationship) {
        return relationship.getId();
    }

    public EmbeddedRelationship findRelationById(RelationTypeMetadata<RelationshipMetadata<EmbeddedRelationshipType>> metadata, Long id) {
        return new EmbeddedRelationship(this.graphDatabaseService.getRelationshipById(id.longValue()));
    }

    public EmbeddedRelationship getSingleRelation(EmbeddedNode source, RelationTypeMetadata<RelationshipMetadata<EmbeddedRelationshipType>> metadata, RelationTypeMetadata.Direction direction) {
        return source.getSingleRelationship((EmbeddedRelationshipType)((RelationshipMetadata)metadata.getDatastoreMetadata()).getDiscriminator(), this.getDirection(direction));
    }

    public Iterable<EmbeddedRelationship> getRelations(EmbeddedNode source, RelationTypeMetadata<RelationshipMetadata<EmbeddedRelationshipType>> metadata, RelationTypeMetadata.Direction direction) {
        return source.getRelationships((EmbeddedRelationshipType)((RelationshipMetadata)metadata.getDatastoreMetadata()).getDiscriminator(), this.getDirection(direction));
    }

    public EmbeddedNode getFrom(EmbeddedRelationship relationship) {
        return relationship.getStartNode();
    }

    public EmbeddedNode getTo(EmbeddedRelationship relationship) {
        return relationship.getEndNode();
    }

    private EmbeddedDirection getDirection(RelationTypeMetadata.Direction direction) {
        switch (direction) {
            case FROM: {
                return EmbeddedDirection.OUTGOING;
            }
            case TO: {
                return EmbeddedDirection.INCOMING;
            }
        }
        throw new XOException("Unsupported direction " + direction);
    }

    public void flush(Iterable<EmbeddedRelationship> relationships) {
        for (EmbeddedRelationship relationship : relationships) {
            relationship.flush();
        }
    }

    public void afterCompletion(EmbeddedRelationship relationship, boolean clear) {
        if (clear) {
            relationship.clear();
        }
    }
}

