/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.api;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.neo4j.embedded.api.DatabaseManagementServiceBuilderFactory;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedDatastore;
import com.buschmais.xo.spi.bootstrap.XODatastoreProvider;
import com.buschmais.xo.spi.datastore.Datastore;
import com.google.common.base.CaseFormat;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedNeo4jXOProvider
implements XODatastoreProvider {
    Pattern NEO4J_PROPERTY_PATTERN = Pattern.compile("neo4j\\.(.*)");
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedNeo4jXOProvider.class);

    public Datastore<?, ?, ?, ?, ?> createDatastore(XOUnit xoUnit) {
        URI uri = xoUnit.getUri();
        DatabaseManagementServiceBuilderFactory databaseManagementServiceBuilderFactory = this.lookupFactory(uri);
        DatabaseManagementServiceBuilder databaseManagementServiceBuilder = databaseManagementServiceBuilderFactory.createDatabaseManagementServiceBuilder(uri);
        Map<String, String> neo4jProperties = this.getNeo4jProperties(xoUnit.getProperties());
        databaseManagementServiceBuilder.setConfigRaw(neo4jProperties);
        databaseManagementServiceBuilder.setConfig(GraphDatabaseInternalSettings.track_cursor_close, (Object)false);
        DatabaseManagementService managementService = databaseManagementServiceBuilder.build();
        return new EmbeddedDatastore(managementService, managementService.database("neo4j"));
    }

    DatabaseManagementServiceBuilderFactory lookupFactory(URI uri) {
        String factoryClass = this.getFactoryClassName(uri);
        LOG.debug("try to lookup provider-class {}", (Object)factoryClass);
        try {
            return (DatabaseManagementServiceBuilderFactory)Class.forName(factoryClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new XOException("Cannot create datastore factory.", (Throwable)e);
        }
    }

    private String getFactoryClassName(URI uri) {
        String protocol = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, uri.getScheme());
        return DatabaseManagementServiceBuilderFactory.class.getPackage().getName() + "." + protocol + DatabaseManagementServiceBuilderFactory.class.getSimpleName();
    }

    public Class<? extends Enum<? extends XODatastoreProvider.ConfigurationProperty>> getConfigurationProperties() {
        return null;
    }

    private Map<String, String> getNeo4jProperties(Properties properties) {
        HashMap<String, String> neo4jProperties = new HashMap<String, String>();
        for (String propertyName : properties.stringPropertyNames()) {
            Matcher matcher = this.NEO4J_PROPERTY_PATTERN.matcher(propertyName);
            if (!matcher.matches()) continue;
            String neo4jProperty = matcher.group(1);
            neo4jProperties.put(neo4jProperty, properties.getProperty(propertyName));
        }
        return neo4jProperties;
    }
}

