/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.impl.model;

import com.buschmais.xo.neo4j.api.model.Neo4jNode;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedDatastoreTransaction;
import com.buschmais.xo.neo4j.embedded.impl.model.AbstractEmbeddedPropertyContainer;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedDirection;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedLabel;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedRelationship;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedRelationshipType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class EmbeddedNode
extends AbstractEmbeddedPropertyContainer<Node>
implements Neo4jNode<EmbeddedLabel, EmbeddedRelationship, EmbeddedRelationshipType, EmbeddedDirection> {
    private final Set<EmbeddedLabel> labels = new HashSet<EmbeddedLabel>();

    public EmbeddedNode(EmbeddedDatastoreTransaction transaction, Node node) {
        super(transaction, (Entity)node);
        for (Label label : node.getLabels()) {
            this.labels.add(new EmbeddedLabel(label));
        }
    }

    @Override
    public Node getDelegate() {
        return this.transaction.getTransaction().getNodeById(this.id);
    }

    public void delete() {
        this.getDelegate().delete();
    }

    public Iterable<EmbeddedRelationship> getRelationships(EmbeddedRelationshipType type, EmbeddedDirection dir) {
        Iterable relationships = this.getDelegate().getRelationships(dir.getDelegate(), new RelationshipType[]{type.getDelegate()});
        return () -> {
            final Iterator iterator = relationships.iterator();
            return new Iterator<EmbeddedRelationship>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public EmbeddedRelationship next() {
                    return EmbeddedNode.this.getEmbeddedRelationship((Relationship)iterator.next());
                }
            };
        };
    }

    public boolean hasRelationship(EmbeddedRelationshipType type, EmbeddedDirection dir) {
        return this.getDelegate().hasRelationship(dir.getDelegate(), new RelationshipType[]{type.getDelegate()});
    }

    public EmbeddedRelationship getSingleRelationship(EmbeddedRelationshipType type, EmbeddedDirection dir) {
        Relationship relationship = this.getDelegate().getSingleRelationship(type.getDelegate(), dir.getDelegate());
        return relationship != null ? this.getEmbeddedRelationship(relationship) : null;
    }

    public EmbeddedRelationship createRelationshipTo(EmbeddedNode otherNode, EmbeddedRelationshipType type) {
        return this.getEmbeddedRelationship(this.getDelegate().createRelationshipTo(otherNode.getDelegate(), type.getDelegate()));
    }

    public void addLabel(EmbeddedLabel label) {
        this.getDelegate().addLabel(label.getDelegate());
        this.labels.add(label);
    }

    public void removeLabel(EmbeddedLabel label) {
        this.getDelegate().removeLabel(label.getDelegate());
        this.labels.remove(label);
    }

    public Set<EmbeddedLabel> getLabels() {
        return this.labels;
    }

    private EmbeddedRelationship getEmbeddedRelationship(Relationship relationship) {
        return new EmbeddedRelationship(this.transaction, relationship);
    }
}

