/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.impl.datastore;

import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.api.annotation.Cypher;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedDatastoreSessionImpl;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedDatastoreTransaction;
import com.buschmais.xo.neo4j.spi.CypherQuery;
import com.buschmais.xo.neo4j.spi.CypherQueryResultIterator;
import com.buschmais.xo.neo4j.spi.Notification;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedCypherQuery
implements CypherQuery {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedCypherQuery.class);
    private final EmbeddedDatastoreSessionImpl embeddedNeo4jDatastoreSession;

    public EmbeddedCypherQuery(EmbeddedDatastoreSessionImpl embeddedNeo4jDatastoreSession) {
        this.embeddedNeo4jDatastoreSession = embeddedNeo4jDatastoreSession;
    }

    public ResultIterator<Map<String, Object>> execute(Cypher expression, Map<String, Object> parameters) {
        return this.execute(expression.value(), parameters);
    }

    public ResultIterator<Map<String, Object>> execute(String expression, Map<String, Object> parameters) {
        Map convertedParameters = (Map)this.embeddedNeo4jDatastoreSession.convertParameter(parameters);
        EmbeddedDatastoreTransaction datastoreTransaction = this.embeddedNeo4jDatastoreSession.getDatastoreTransaction();
        if (datastoreTransaction.isActive()) {
            return this.executeTransactional(expression, convertedParameters, datastoreTransaction);
        }
        return this.executeNonTransactional(expression, convertedParameters);
    }

    private ResultIterator<Map<String, Object>> executeTransactional(String expression, Map<String, Object> parameters, EmbeddedDatastoreTransaction datastoreTransaction) {
        final Result executionResult = datastoreTransaction.getTransaction().execute(expression, parameters);
        final List columns = executionResult.columns();
        return new ResultIterator<Map<String, Object>>(){

            public boolean hasNext() {
                return executionResult.hasNext();
            }

            public Map<String, Object> next() {
                return EmbeddedCypherQuery.this.convertRow(executionResult.next(), columns);
            }

            public void remove() {
                throw new XOException("Remove operation is not supported for query results.");
            }

            public void close() {
                executionResult.close();
            }
        };
    }

    private ResultIterator<Map<String, Object>> executeNonTransactional(String expression, Map<String, Object> parameters) {
        return (ResultIterator)this.embeddedNeo4jDatastoreSession.getGraphDatabaseService().executeTransactionally(expression, parameters, result -> {
            List columns = result.columns();
            List rows = result.stream().map(row -> this.convertRow((Map<String, Object>)row, columns)).collect(Collectors.toList());
            final Iterator iterator = rows.iterator();
            return new CypherQueryResultIterator((Result)result){
                final /* synthetic */ Result val$result;
                {
                    this.val$result = result;
                }

                protected Logger getLogger() {
                    return log;
                }

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public Map<String, Object> next() {
                    return (Map)iterator.next();
                }

                public void remove() {
                    throw new XOException("Remove operation is not supported for query results.");
                }

                public List<Notification> dispose() {
                    return StreamSupport.stream(this.val$result.getNotifications().spliterator(), false).map(n -> Notification.builder().title(n.getTitle()).description(n.getDescription()).code(n.getCode()).severity(Notification.Severity.from((String)n.getSeverity().name())).offset(n.getPosition().getOffset()).line(n.getPosition().getLine()).column(n.getPosition().getColumn()).build()).collect(Collectors.toList());
                }
            };
        });
    }

    private Map<String, Object> convertRow(Map<String, Object> row, List<String> columns) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(row.size(), 1.0f);
        for (String column : columns) {
            result.put(column, this.embeddedNeo4jDatastoreSession.convertValue(row.get(column)));
        }
        return result;
    }
}

