/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.api;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.neo4j.embedded.api.DatabaseManagementServiceFactory;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedDatastore;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedLabel;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedRelationshipType;
import com.buschmais.xo.neo4j.spi.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.spi.metadata.RelationshipMetadata;
import com.buschmais.xo.spi.bootstrap.XODatastoreProvider;
import com.buschmais.xo.spi.datastore.Datastore;
import com.google.common.base.CaseFormat;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.config.Setting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedNeo4jXOProvider
implements XODatastoreProvider<NodeMetadata<EmbeddedLabel>, EmbeddedLabel, RelationshipMetadata<EmbeddedRelationshipType>, EmbeddedRelationshipType> {
    private static final String NEO4J_PROPERTY_PREFIX = "neo4j.";
    private static final Pattern NEO4J_PROPERTY_PATTERN = Pattern.compile("neo4j\\.(.*)");
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedNeo4jXOProvider.class);

    public Datastore<?, NodeMetadata<EmbeddedLabel>, EmbeddedLabel, RelationshipMetadata<EmbeddedRelationshipType>, EmbeddedRelationshipType> createDatastore(XOUnit xoUnit) {
        URI uri = xoUnit.getUri();
        Map<String, String> neo4jProperties = this.getNeo4jProperties(xoUnit.getProperties());
        Config config = Config.newBuilder().setRaw(neo4jProperties).build();
        DatabaseManagementServiceFactory databaseManagementServiceFactory = this.lookupFactory(uri);
        DatabaseManagementService databaseManagementService = databaseManagementServiceFactory.createDatabaseManagementService(uri, config);
        return new EmbeddedDatastore(databaseManagementService, databaseManagementService.database("neo4j"));
    }

    DatabaseManagementServiceFactory lookupFactory(URI uri) {
        String factoryClass = this.getFactoryClassName(uri);
        LOG.debug("try to lookup provider-class {}", (Object)factoryClass);
        try {
            return (DatabaseManagementServiceFactory)Class.forName(factoryClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new XOException("Cannot create datastore factory.", (Throwable)e);
        }
    }

    private String getFactoryClassName(URI uri) {
        String protocol = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, uri.getScheme());
        return DatabaseManagementServiceFactory.class.getPackage().getName() + "." + protocol + DatabaseManagementServiceFactory.class.getSimpleName();
    }

    public Class<? extends Enum<? extends XODatastoreProvider.ConfigurationProperty>> getConfigurationProperties() {
        return null;
    }

    private Map<String, String> getNeo4jProperties(Properties properties) {
        HashMap<String, String> neo4jProperties = new HashMap<String, String>();
        for (String propertyName : properties.stringPropertyNames()) {
            Matcher matcher = NEO4J_PROPERTY_PATTERN.matcher(propertyName);
            if (!matcher.matches()) continue;
            String neo4jProperty = matcher.group(1);
            neo4jProperties.put(neo4jProperty, properties.getProperty(propertyName));
        }
        return neo4jProperties;
    }

    public static PropertiesBuilder propertiesBuilder() {
        return new PropertiesBuilder();
    }

    public static class PropertiesBuilder {
        private final Properties properties = new Properties();

        private PropertiesBuilder() {
        }

        public <T> PropertiesBuilder property(Setting<T> setting, T value) {
            if (value instanceof List) {
                return this.property(setting.name(), ((List)value).stream().map(Object::toString).collect(Collectors.joining(",")));
            }
            return this.property(setting.name(), value);
        }

        public <T> PropertiesBuilder property(String setting, T value) {
            this.properties.setProperty(EmbeddedNeo4jXOProvider.NEO4J_PROPERTY_PREFIX + setting, value.toString());
            return this;
        }

        public Properties build() {
            return this.properties;
        }
    }
}

