/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.impl.model;

import com.buschmais.xo.neo4j.api.model.Neo4jRelationship;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedDatastoreTransaction;
import com.buschmais.xo.neo4j.embedded.impl.model.AbstractEmbeddedPropertyContainer;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedDirection;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedLabel;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedNode;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedRelationshipType;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Relationship;

public class EmbeddedRelationship
extends AbstractEmbeddedPropertyContainer<Relationship>
implements Neo4jRelationship<EmbeddedNode, EmbeddedLabel, EmbeddedRelationship, EmbeddedRelationshipType, EmbeddedDirection> {
    private final EmbeddedNode startNode;
    private final EmbeddedRelationshipType type;
    private final EmbeddedNode endNode;

    public EmbeddedRelationship(EmbeddedDatastoreTransaction transaction, Relationship relationship) {
        super(transaction, (Entity)relationship);
        this.startNode = new EmbeddedNode(transaction, relationship.getStartNode());
        this.type = new EmbeddedRelationshipType(relationship.getType());
        this.endNode = new EmbeddedNode(transaction, relationship.getEndNode());
    }

    @Override
    public Relationship getDelegate() {
        return this.transaction.getTransaction().getRelationshipById(this.id);
    }

    public void delete() {
        this.getDelegate().delete();
    }

    public EmbeddedNode getStartNode() {
        return this.startNode;
    }

    public EmbeddedNode getEndNode() {
        return this.endNode;
    }

    public EmbeddedRelationshipType getType() {
        return this.type;
    }
}

