/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.datastore;

import com.buschmais.xo.api.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.api.metadata.reflection.PropertyMethod;
import com.buschmais.xo.neo4j.remote.impl.datastore.RemoteDatastoreSessionCache;
import com.buschmais.xo.neo4j.remote.impl.datastore.StatementBatchBuilder;
import com.buschmais.xo.neo4j.remote.impl.datastore.StatementExecutor;
import com.buschmais.xo.neo4j.remote.impl.model.AbstractRemotePropertyContainer;
import com.buschmais.xo.neo4j.remote.impl.model.state.AbstractPropertyContainerState;
import com.buschmais.xo.neo4j.spi.metadata.PropertyMetadata;
import com.buschmais.xo.spi.datastore.DatastorePropertyManager;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.Entity;

public abstract class AbstractRemoteDatastorePropertyManager<T extends AbstractRemotePropertyContainer>
implements DatastorePropertyManager<T, PropertyMetadata> {
    protected StatementExecutor statementExecutor;
    protected RemoteDatastoreSessionCache datastoreSessionCache;

    public AbstractRemoteDatastorePropertyManager(StatementExecutor statementExecutor, RemoteDatastoreSessionCache datastoreSessionCache) {
        this.statementExecutor = statementExecutor;
        this.datastoreSessionCache = datastoreSessionCache;
    }

    public void setProperty(T entity, PrimitivePropertyMethodMetadata<PropertyMetadata> metadata, Object value) {
        this.ensureLoaded(entity);
        ((AbstractRemotePropertyContainer)entity).setProperty(((PropertyMetadata)metadata.getDatastoreMetadata()).getName(), value);
    }

    public boolean hasProperty(T entity, PrimitivePropertyMethodMetadata<PropertyMetadata> metadata) {
        this.ensureLoaded(entity);
        return ((AbstractRemotePropertyContainer)entity).hasProperty(((PropertyMetadata)metadata.getDatastoreMetadata()).getName());
    }

    public void removeProperty(T entity, PrimitivePropertyMethodMetadata<PropertyMetadata> metadata) {
        this.ensureLoaded(entity);
        ((AbstractRemotePropertyContainer)entity).removeProperty(((PropertyMetadata)metadata.getDatastoreMetadata()).getName());
    }

    public Object getProperty(T entity, PrimitivePropertyMethodMetadata<PropertyMetadata> metadata) {
        this.ensureLoaded(entity);
        Class type = ((PropertyMethod)metadata.getAnnotatedMethod()).getType();
        Object value = ((AbstractRemotePropertyContainer)entity).getProperty(((PropertyMetadata)metadata.getDatastoreMetadata()).getName());
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type)) {
                return number.intValue();
            }
        }
        return value;
    }

    protected void flush(StatementBatchBuilder batchBuilder, T entity, String pattern, String identifier) {
        Object state = ((AbstractRemotePropertyContainer)entity).getState();
        Map<String, Object> writeCache = ((AbstractPropertyContainerState)state).getWriteCache();
        if (writeCache != null && !writeCache.isEmpty()) {
            String statement = "MATCH " + pattern + " WHERE id(" + identifier + ")=entry['id'] SET " + identifier + "+=entry['" + identifier + "'] RETURN collect(id(" + identifier + "))";
            batchBuilder.add(statement, Values.parameters((Object[])new Object[]{"id", ((AbstractRemotePropertyContainer)entity).getId(), identifier, writeCache}));
        }
    }

    public final void afterCompletion(T entity, boolean clear) {
        ((AbstractPropertyContainerState)((AbstractRemotePropertyContainer)entity).getState()).afterCompletion(clear);
    }

    protected final void ensureLoaded(T entity) {
        if (!((AbstractPropertyContainerState)((AbstractRemotePropertyContainer)entity).getState()).isLoaded()) {
            Entity state = this.load(entity);
            ((AbstractPropertyContainerState)((AbstractRemotePropertyContainer)entity).getState()).load(state.asMap());
        }
    }

    protected Map<String, Object> getProperties(Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> exampleEntity) {
        HashMap<String, Object> properties = new HashMap<String, Object>(exampleEntity.size());
        for (Map.Entry<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> entry : exampleEntity.entrySet()) {
            properties.put(((PropertyMetadata)entry.getKey().getDatastoreMetadata()).getName(), entry.getValue());
        }
        return properties;
    }

    protected abstract Entity load(T var1);
}

