/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.datastore;

import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.neo4j.api.annotation.Cypher;
import com.buschmais.xo.neo4j.remote.impl.datastore.StatementExecutor;
import com.buschmais.xo.neo4j.spi.helper.Converter;
import com.buschmais.xo.spi.datastore.DatastoreQuery;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;

public class RemoteDatastoreCypherQuery
implements DatastoreQuery<Cypher> {
    private final StatementExecutor statementExecutor;
    private final Converter parameterConverter;
    private final Converter valueConverter;

    public RemoteDatastoreCypherQuery(StatementExecutor statementExecutor, Converter parameterConverter, Converter valueConverter) {
        this.statementExecutor = statementExecutor;
        this.parameterConverter = parameterConverter;
        this.valueConverter = valueConverter;
    }

    public ResultIterator<Map<String, Object>> execute(Cypher query, Map<String, Object> parameters) {
        return this.execute(query.value(), parameters);
    }

    public ResultIterator<Map<String, Object>> execute(String query, Map<String, Object> parameters) {
        final Result result = this.statementExecutor.execute(query, (Map)this.parameterConverter.convert(parameters));
        return new ResultIterator<Map<String, Object>>(){

            public boolean hasNext() {
                return result.hasNext();
            }

            public Map<String, Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Record record = result.next();
                Map row = record.asMap();
                LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>(row.size(), 1.0f);
                for (Map.Entry entry : row.entrySet()) {
                    String column = (String)entry.getKey();
                    Object value = entry.getValue();
                    result2.put(column, RemoteDatastoreCypherQuery.this.valueConverter.convert(value));
                }
                return result2;
            }

            public void close() {
                result.consume();
            }
        };
    }
}

