/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.datastore;

import com.buschmais.xo.api.ResultIterable;
import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.neo4j.remote.impl.converter.RemoteEntityConverter;
import com.buschmais.xo.neo4j.remote.impl.converter.RemoteParameterConverter;
import com.buschmais.xo.neo4j.remote.impl.datastore.RemoteDatastoreSessionCache;
import com.buschmais.xo.neo4j.remote.impl.datastore.StatementExecutor;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteLabel;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteNode;
import com.buschmais.xo.neo4j.spi.AbstractNeo4jRepository;
import com.buschmais.xo.neo4j.spi.helper.Converter;
import com.buschmais.xo.neo4j.spi.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.spi.metadata.PropertyMetadata;
import com.buschmais.xo.spi.session.XOSession;
import java.util.Arrays;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Values;

public class RemoteNeo4jRepositoryImpl
extends AbstractNeo4jRepository<RemoteLabel> {
    private final StatementExecutor statementExecutor;
    private final Converter parameterConverter;
    private final Converter valueConverter;

    public RemoteNeo4jRepositoryImpl(XOSession<NodeMetadata<RemoteLabel>, RemoteLabel, ?, ?> xoSession, StatementExecutor statementExecutor, RemoteDatastoreSessionCache sessionCache) {
        super(xoSession);
        this.statementExecutor = statementExecutor;
        this.parameterConverter = new Converter(Arrays.asList(new RemoteParameterConverter()));
        this.valueConverter = new Converter(Arrays.asList(new RemoteEntityConverter(sessionCache)));
    }

    protected <T> ResultIterable<T> find(RemoteLabel label, PropertyMetadata datastoreMetadata, Object value) {
        String statement = String.format("MATCH (n:%s{%s:$value}) RETURN n", label.getName(), datastoreMetadata.getName());
        final Result statementResult = this.statementExecutor.execute(statement, Values.parameters((Object[])new Object[]{"value", this.parameterConverter.convert(value)}));
        return this.xoSession.toResult((ResultIterator)new ResultIterator<RemoteNode>(){

            public boolean hasNext() {
                return statementResult.hasNext();
            }

            public RemoteNode next() {
                Record record = statementResult.next();
                return (RemoteNode)RemoteNeo4jRepositoryImpl.this.valueConverter.convert((Object)record.get("n").asNode());
            }

            public void close() {
                statementResult.consume();
            }
        });
    }
}

