/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.model.state;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class StateTracker<T, C extends Collection<T>> {
    private C elements;
    private Set<T> added = new HashSet<T>();
    private Set<T> removed = new HashSet<T>();

    public StateTracker(C elements) {
        this.elements = elements;
    }

    public void load(C elements) {
        this.elements = elements;
        this.added.clear();
        this.removed.clear();
    }

    public void add(T t) {
        this.elements.add(t);
        if (!this.removed.remove(t)) {
            this.added.add(t);
        }
    }

    public void addAll(C added) {
        for (Object t : added) {
            this.add(t);
        }
    }

    public void remove(T t) {
        this.elements.remove(t);
        if (!this.added.remove(t)) {
            this.removed.add(t);
        }
    }

    public void removeAll(C removed) {
        for (Object t : removed) {
            this.remove(t);
        }
    }

    public Set<T> getAdded() {
        return this.added;
    }

    public Set<T> getRemoved() {
        return this.removed;
    }

    public C getElements() {
        return this.elements;
    }

    public void flush() {
        this.added.clear();
        this.removed.clear();
    }

    public String toString() {
        return "StateTracker{elements=" + this.elements + ", added=" + this.added + ", removed=" + this.removed + '}';
    }
}

