/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.datastore;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.api.metadata.type.RelationTypeMetadata;
import com.buschmais.xo.neo4j.remote.impl.datastore.AbstractRemoteDatastorePropertyManager;
import com.buschmais.xo.neo4j.remote.impl.datastore.RemoteDatastoreSessionCache;
import com.buschmais.xo.neo4j.remote.impl.datastore.StatementBatchBuilder;
import com.buschmais.xo.neo4j.remote.impl.datastore.StatementExecutor;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteDirection;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteNode;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteRelationship;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteRelationshipType;
import com.buschmais.xo.neo4j.remote.impl.model.state.NodeState;
import com.buschmais.xo.neo4j.remote.impl.model.state.RelationshipState;
import com.buschmais.xo.neo4j.remote.impl.model.state.StateTracker;
import com.buschmais.xo.neo4j.spi.metadata.PropertyMetadata;
import com.buschmais.xo.neo4j.spi.metadata.RelationshipMetadata;
import com.buschmais.xo.spi.datastore.DatastoreRelationManager;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Relationship;

public class RemoteDatastoreRelationManager
extends AbstractRemoteDatastorePropertyManager<RemoteRelationship>
implements DatastoreRelationManager<RemoteNode, Long, RemoteRelationship, RelationshipMetadata<RemoteRelationshipType>, RemoteRelationshipType, PropertyMetadata> {
    private long idSequence = -1L;

    public RemoteDatastoreRelationManager(StatementExecutor statementExecutor, RemoteDatastoreSessionCache datastoreSessionCache) {
        super(statementExecutor, datastoreSessionCache);
    }

    public boolean isRelation(Object o) {
        return RemoteRelationship.class.isAssignableFrom(o.getClass());
    }

    public RemoteRelationshipType getRelationDiscriminator(RemoteRelationship remoteRelationship) {
        return remoteRelationship.getType();
    }

    public RemoteRelationship createRelation(RemoteNode source, RelationTypeMetadata<RelationshipMetadata<RemoteRelationshipType>> metadata, RelationTypeMetadata.Direction direction, RemoteNode target, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> exampleEntity) {
        RemoteRelationship relationship;
        RemoteDirection inverseRemoteDirection;
        RemoteDirection remoteDirection;
        RemoteNode end;
        RemoteNode start;
        RelationshipMetadata datastoreMetadata = (RelationshipMetadata)metadata.getDatastoreMetadata();
        RemoteRelationshipType type = (RemoteRelationshipType)datastoreMetadata.getDiscriminator();
        switch (direction) {
            case FROM: {
                start = source;
                end = target;
                remoteDirection = RemoteDirection.OUTGOING;
                inverseRemoteDirection = RemoteDirection.INCOMING;
                break;
            }
            case TO: {
                start = target;
                end = source;
                remoteDirection = RemoteDirection.INCOMING;
                inverseRemoteDirection = RemoteDirection.OUTGOING;
                break;
            }
            default: {
                throw new XOException("Unsupported direction " + direction);
            }
        }
        Map<String, Object> properties = this.getProperties(exampleEntity);
        StateTracker<RemoteRelationship, Set<RemoteRelationship>> relationships = this.getRelationships(source, type, remoteDirection);
        if (!datastoreMetadata.isBatchable()) {
            String statement = String.format("MATCH (start),(end) WHERE id(start)=$start and id(end)=$end CREATE (start)-[r:%s]->(end) SET r=$r RETURN id(r) as id", type.getName());
            Record record = this.statementExecutor.getSingleResult(statement, Values.parameters((Object[])new Object[]{"start", start.getId(), "end", end.getId(), "r", properties}));
            long id = record.get("id").asLong();
            RelationshipState relationshipState = new RelationshipState(properties);
            relationship = this.datastoreSessionCache.getRelationship(id, start, type, end, () -> relationshipState);
            relationships.getElements().add(relationship);
        } else {
            long id = this.idSequence--;
            relationship = this.datastoreSessionCache.getRelationship(id, start, type, end, () -> new RelationshipState(properties));
            relationships.add(relationship);
        }
        StateTracker<RemoteRelationship, Set<RemoteRelationship>> inverseRelationships = ((NodeState)target.getState()).getRelationships(inverseRemoteDirection, type);
        if (inverseRelationships != null) {
            inverseRelationships.getElements().add(relationship);
        }
        return relationship;
    }

    public void deleteRelation(RemoteRelationship remoteRelationship) {
        RemoteRelationshipType type = remoteRelationship.getType();
        RemoteNode startNode = remoteRelationship.getStartNode();
        RemoteNode endNode = remoteRelationship.getEndNode();
        StateTracker<RemoteRelationship, Set<RemoteRelationship>> outgoingRelationships = ((NodeState)startNode.getState()).getRelationships(RemoteDirection.OUTGOING, type);
        StateTracker<RemoteRelationship, Set<RemoteRelationship>> incomingRelationships = ((NodeState)endNode.getState()).getRelationships(RemoteDirection.INCOMING, type);
        if (outgoingRelationships != null) {
            outgoingRelationships.remove(remoteRelationship);
        } else if (incomingRelationships != null) {
            incomingRelationships.remove(remoteRelationship);
        }
        if (outgoingRelationships != null) {
            outgoingRelationships.getElements().remove(remoteRelationship);
        }
        if (incomingRelationships != null) {
            incomingRelationships.getElements().remove(remoteRelationship);
        }
    }

    public Long getRelationId(RemoteRelationship remoteRelationship) {
        return remoteRelationship.getId();
    }

    public RemoteRelationship findRelationById(RelationTypeMetadata<RelationshipMetadata<RemoteRelationshipType>> metadata, Long id) {
        String statement = String.format("MATCH (start)-[r:%s]->(end) WHERE id(r)=$id RETURN start,r,end", ((RemoteRelationshipType)((RelationshipMetadata)metadata.getDatastoreMetadata()).getDiscriminator()).getName());
        Record record = this.statementExecutor.getSingleResult(statement, Values.parameters((Object[])new Object[]{"id", id}));
        Node start = record.get("start").asNode();
        Relationship relationship = record.get("r").asRelationship();
        Node end = record.get("end").asNode();
        return this.datastoreSessionCache.getRelationship(start, relationship, end);
    }

    public RemoteRelationship getSingleRelation(RemoteNode source, RelationTypeMetadata<RelationshipMetadata<RemoteRelationshipType>> metadata, RelationTypeMetadata.Direction direction) {
        Iterator<RemoteRelationship> iterator = this.getSingleRelationship(source, metadata, direction).iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public Iterable<RemoteRelationship> getRelations(RemoteNode source, RelationTypeMetadata<RelationshipMetadata<RemoteRelationshipType>> metadata, RelationTypeMetadata.Direction direction) {
        return this.getRelationships(source, (RemoteRelationshipType)((RelationshipMetadata)metadata.getDatastoreMetadata()).getDiscriminator(), this.getRemoteDirection(direction)).getElements();
    }

    public RemoteNode getFrom(RemoteRelationship remoteRelationship) {
        return remoteRelationship.getStartNode();
    }

    public RemoteNode getTo(RemoteRelationship remoteRelationship) {
        return remoteRelationship.getEndNode();
    }

    protected Relationship load(RemoteRelationship entity) {
        return this.fetch(entity.getId());
    }

    private Relationship fetch(Long id) {
        Record record = this.statementExecutor.getSingleResult("MATCH ()-[r]->() WHERE id(r)=$id RETURN r", Values.parameters((Object[])new Object[]{"id", id}));
        return record.get("r").asRelationship();
    }

    private Set<RemoteRelationship> getSingleRelationship(RemoteNode source, RelationTypeMetadata<RelationshipMetadata<RemoteRelationshipType>> metadata, RelationTypeMetadata.Direction direction) {
        Set<RemoteRelationship> relationships = this.getRelationships(source, (RemoteRelationshipType)((RelationshipMetadata)metadata.getDatastoreMetadata()).getDiscriminator(), this.getRemoteDirection(direction)).getElements();
        if (relationships.size() > 1) {
            throw new XOException("Found more than one relationship for node=" + source + ", type=" + ((RelationshipMetadata)metadata.getDatastoreMetadata()).getDiscriminator() + ", direction=" + direction + ", relationships=" + relationships);
        }
        return relationships;
    }

    public void flush(Iterable<RemoteRelationship> relationships) {
        try (StatementBatchBuilder batchBuilder = new StatementBatchBuilder(this.statementExecutor);){
            for (RemoteRelationship relationship : relationships) {
                this.flush(batchBuilder, relationship, "()-[r]->()", "r");
                ((RelationshipState)relationship.getState()).flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateTracker<RemoteRelationship, Set<RemoteRelationship>> getRelationships(RemoteNode source, RemoteRelationshipType type, RemoteDirection remoteDirection) {
        StateTracker<RemoteRelationship, Set<RemoteRelationship>> trackedRelationships = ((NodeState)source.getState()).getRelationships(remoteDirection, type);
        if (trackedRelationships == null) {
            String sourceIdentifier;
            switch (remoteDirection) {
                case OUTGOING: {
                    sourceIdentifier = "start";
                    break;
                }
                case INCOMING: {
                    sourceIdentifier = "end";
                    break;
                }
                default: {
                    throw new XOException("Direction not supported: " + (Object)((Object)remoteDirection));
                }
            }
            String statement = String.format("MATCH (start)-[r:%s]->(end) WHERE id(%s)=$id RETURN start,r,end", type.getName(), sourceIdentifier);
            Result statementResult = this.statementExecutor.execute(statement, Values.parameters((Object[])new Object[]{"id", source.getId()}));
            LinkedHashSet<RemoteRelationship> loaded = new LinkedHashSet<RemoteRelationship>();
            try {
                while (statementResult.hasNext()) {
                    Record record = statementResult.next();
                    Node start = record.get("start").asNode();
                    Relationship relationship = record.get("r").asRelationship();
                    Node end = record.get("end").asNode();
                    RemoteRelationship remoteRelationship = this.datastoreSessionCache.getRelationship(start, relationship, end);
                    loaded.add(remoteRelationship);
                }
            }
            finally {
                statementResult.consume();
            }
            trackedRelationships = new StateTracker(loaded);
            ((NodeState)source.getState()).setRelationships(remoteDirection, type, trackedRelationships);
        }
        return trackedRelationships;
    }

    private RemoteDirection getRemoteDirection(RelationTypeMetadata.Direction direction) {
        switch (direction) {
            case FROM: {
                return RemoteDirection.OUTGOING;
            }
            case TO: {
                return RemoteDirection.INCOMING;
            }
        }
        throw new XOException("Direction not supported " + direction);
    }
}

