/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.model.state;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteDirection;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteLabel;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteRelationship;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteRelationshipType;
import com.buschmais.xo.neo4j.remote.impl.model.state.AbstractPropertyContainerState;
import com.buschmais.xo.neo4j.remote.impl.model.state.StateTracker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NodeState
extends AbstractPropertyContainerState {
    private StateTracker<RemoteLabel, Set<RemoteLabel>> labels = new StateTracker(new HashSet());
    private Map<RemoteRelationshipType, StateTracker<RemoteRelationship, Set<RemoteRelationship>>> outgoingRelationships = new HashMap<RemoteRelationshipType, StateTracker<RemoteRelationship, Set<RemoteRelationship>>>();
    private Map<RemoteRelationshipType, StateTracker<RemoteRelationship, Set<RemoteRelationship>>> incomingRelationships = new HashMap<RemoteRelationshipType, StateTracker<RemoteRelationship, Set<RemoteRelationship>>>();

    public NodeState() {
        super(null);
    }

    public NodeState(Set<RemoteLabel> labels, Map<String, Object> readCache) {
        super(readCache);
        this.labels = new StateTracker(labels);
    }

    public StateTracker<RemoteLabel, Set<RemoteLabel>> getLabels() {
        return this.labels;
    }

    public Map<RemoteRelationshipType, StateTracker<RemoteRelationship, Set<RemoteRelationship>>> getOutgoingRelationships() {
        return this.outgoingRelationships;
    }

    public Map<RemoteRelationshipType, StateTracker<RemoteRelationship, Set<RemoteRelationship>>> getIncomingRelationships() {
        return this.incomingRelationships;
    }

    public StateTracker<RemoteRelationship, Set<RemoteRelationship>> getOutgoingRelationships(RemoteRelationshipType type) {
        return this.outgoingRelationships.get(type);
    }

    public StateTracker<RemoteRelationship, Set<RemoteRelationship>> getIncomingRelationships(RemoteRelationshipType type) {
        return this.incomingRelationships.get(type);
    }

    public StateTracker<RemoteRelationship, Set<RemoteRelationship>> getRelationships(RemoteDirection remoteDirection, RemoteRelationshipType type) {
        switch (remoteDirection) {
            case OUTGOING: {
                return this.getOutgoingRelationships(type);
            }
            case INCOMING: {
                return this.getIncomingRelationships(type);
            }
        }
        throw new XOException("Unknown direction " + remoteDirection);
    }

    public void setRelationships(RemoteDirection remoteDirection, RemoteRelationshipType type, StateTracker<RemoteRelationship, Set<RemoteRelationship>> relationships) {
        switch (remoteDirection) {
            case OUTGOING: {
                this.outgoingRelationships.put(type, relationships);
                break;
            }
            case INCOMING: {
                this.incomingRelationships.put(type, relationships);
                break;
            }
            default: {
                throw new XOException("Unknown direction " + remoteDirection);
            }
        }
    }

    @Override
    public void flush() {
        super.flush();
        this.labels.flush();
        for (StateTracker<RemoteRelationship, Set<RemoteRelationship>> tracker : this.outgoingRelationships.values()) {
            tracker.flush();
        }
        for (StateTracker<RemoteRelationship, Set<RemoteRelationship>> tracker : this.incomingRelationships.values()) {
            tracker.flush();
        }
    }

    @Override
    public void afterCompletion(boolean clear) {
        super.afterCompletion(clear);
        this.outgoingRelationships.clear();
        this.incomingRelationships.clear();
    }
}

