/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.datastore;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.api.TypedNeo4jRepository;
import com.buschmais.xo.neo4j.api.annotation.Cypher;
import com.buschmais.xo.neo4j.remote.impl.converter.RemoteEntityConverter;
import com.buschmais.xo.neo4j.remote.impl.converter.RemoteParameterConverter;
import com.buschmais.xo.neo4j.remote.impl.converter.RemotePathConverter;
import com.buschmais.xo.neo4j.remote.impl.datastore.RemoteCypherQuery;
import com.buschmais.xo.neo4j.remote.impl.datastore.RemoteDatastoreEntityManager;
import com.buschmais.xo.neo4j.remote.impl.datastore.RemoteDatastoreRelationManager;
import com.buschmais.xo.neo4j.remote.impl.datastore.RemoteDatastoreSessionCache;
import com.buschmais.xo.neo4j.remote.impl.datastore.RemoteDatastoreTransaction;
import com.buschmais.xo.neo4j.remote.impl.datastore.RemoteNeo4jRepositoryImpl;
import com.buschmais.xo.neo4j.remote.impl.datastore.StatementConfig;
import com.buschmais.xo.neo4j.remote.impl.datastore.StatementExecutor;
import com.buschmais.xo.neo4j.remote.impl.datastore.TypedRemoteRepositoryImpl;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteLabel;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteNode;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteRelationship;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteRelationshipType;
import com.buschmais.xo.neo4j.spi.AbstractNeo4jDatastoreSession;
import com.buschmais.xo.neo4j.spi.helper.Converter;
import com.buschmais.xo.neo4j.spi.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.spi.metadata.PropertyMetadata;
import com.buschmais.xo.neo4j.spi.metadata.RelationshipMetadata;
import com.buschmais.xo.spi.datastore.DatastoreEntityManager;
import com.buschmais.xo.spi.datastore.DatastoreQuery;
import com.buschmais.xo.spi.datastore.DatastoreRelationManager;
import com.buschmais.xo.spi.datastore.DatastoreTransaction;
import com.buschmais.xo.spi.reflection.ClassHelper;
import com.buschmais.xo.spi.session.XOSession;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.neo4j.driver.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDatastoreSession
extends AbstractNeo4jDatastoreSession<RemoteNode, RemoteLabel, RemoteRelationship, RemoteRelationshipType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDatastoreSession.class);
    private final Session session;
    private final RemoteDatastoreTransaction transaction;
    private final StatementExecutor statementExecutor;
    private final RemoteDatastoreEntityManager entityManager;
    private final RemoteDatastoreRelationManager relationManager;
    private final RemoteDatastoreSessionCache datastoreSessionCache;
    private final Converter parameterConverter;
    private final Converter valueConverter;

    public RemoteDatastoreSession(Session session, StatementConfig statementConfig) {
        this.session = session;
        this.transaction = new RemoteDatastoreTransaction(session);
        this.statementExecutor = new StatementExecutor(this.transaction, statementConfig);
        this.datastoreSessionCache = new RemoteDatastoreSessionCache();
        this.parameterConverter = new Converter(Arrays.asList(new RemoteParameterConverter()));
        this.valueConverter = new Converter(Arrays.asList(new RemoteEntityConverter(this.datastoreSessionCache), new RemotePathConverter(this.datastoreSessionCache)));
        this.entityManager = new RemoteDatastoreEntityManager(this.statementExecutor, this.datastoreSessionCache);
        this.relationManager = new RemoteDatastoreRelationManager(this.statementExecutor, this.datastoreSessionCache);
    }

    public DatastoreTransaction getDatastoreTransaction() {
        return this.transaction;
    }

    public DatastoreEntityManager<Long, RemoteNode, NodeMetadata<RemoteLabel>, RemoteLabel, PropertyMetadata> getDatastoreEntityManager() {
        return this.entityManager;
    }

    public DatastoreRelationManager<RemoteNode, Long, RemoteRelationship, RelationshipMetadata<RemoteRelationshipType>, RemoteRelationshipType, PropertyMetadata> getDatastoreRelationManager() {
        return this.relationManager;
    }

    public Class<? extends Annotation> getDefaultQueryLanguage() {
        return Cypher.class;
    }

    public <QL extends Annotation> DatastoreQuery<QL> createQuery(Class<QL> queryLanguage) {
        if (Cypher.class.equals(queryLanguage)) {
            return new RemoteCypherQuery(this.statementExecutor, this.parameterConverter, this.valueConverter);
        }
        throw new XOException("Unsupported query language: " + queryLanguage.getName());
    }

    public <R> R createRepository(XOSession xoSession, Class<R> type) {
        if (TypedNeo4jRepository.class.isAssignableFrom(type)) {
            Class typeParameter = ClassHelper.getTypeParameter(TypedNeo4jRepository.class, type);
            if (typeParameter == null) {
                throw new XOException("Cannot determine type parameter for " + type.getName());
            }
            return (R)((Object)new TypedRemoteRepositoryImpl(xoSession, typeParameter, this.statementExecutor, this.datastoreSessionCache));
        }
        return (R)((Object)new RemoteNeo4jRepositoryImpl(xoSession, this.statementExecutor, this.datastoreSessionCache));
    }

    public void close() {
        if (this.session.isOpen()) {
            this.session.close();
        } else {
            LOGGER.warn("Session is already closed.");
        }
    }

    public Object convertValue(Object value) {
        return this.valueConverter.convert(value);
    }

    public Object convertParameter(Object value) {
        return this.parameterConverter.convert(value);
    }
}

