/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.datastore;

import com.buschmais.xo.neo4j.remote.impl.datastore.StatementExecutor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;

public class StatementBatchBuilder
implements AutoCloseable {
    private StatementExecutor statementExecutor;
    private Map<String, BatchEntry> batches = new LinkedHashMap<String, BatchEntry>();

    public StatementBatchBuilder(StatementExecutor statementExecutor) {
        this.statementExecutor = statementExecutor;
    }

    public void add(String key, Value parameters) {
        this.add(key, parameters, null);
    }

    public void add(String key, Value parameters, Callback callback) {
        BatchEntry batch = this.batches.computeIfAbsent(key, k -> new BatchEntry(callback));
        batch.add(parameters);
    }

    @Override
    public void close() {
        for (Map.Entry<String, BatchEntry> entry : this.batches.entrySet()) {
            String statement = entry.getKey();
            BatchEntry batchEntry = entry.getValue();
            List<Value> batch = batchEntry.getBatch();
            if (batch.isEmpty()) continue;
            String batchStatement = "UNWIND $batch as entry " + statement;
            Record result = this.statementExecutor.getSingleResult(batchStatement, Values.parameters((Object[])new Object[]{"batch", batch}));
            Callback callback = batchEntry.getCallback();
            if (callback == null) continue;
            callback.process(result);
        }
        this.batches.clear();
    }

    @FunctionalInterface
    public static interface Callback {
        public void process(Record var1);
    }

    private static class BatchEntry {
        private List<Value> batch = new ArrayList<Value>();
        private Callback callback;

        public BatchEntry(Callback callback) {
            this.callback = callback;
        }

        void add(Value parameters) {
            this.batch.add(parameters);
        }

        public List<Value> getBatch() {
            return this.batch;
        }

        public Callback getCallback() {
            return this.callback;
        }
    }
}

