/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.datastore;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.remote.impl.datastore.RemoteDatastoreTransaction;
import com.buschmais.xo.neo4j.remote.impl.datastore.StatementConfig;
import com.buschmais.xo.spi.logging.LogLevel;
import java.util.Map;
import org.neo4j.driver.QueryRunner;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementExecutor.class);
    private RemoteDatastoreTransaction transaction;
    private StatementConfig statementConfig;

    public StatementExecutor(RemoteDatastoreTransaction transaction, StatementConfig statementConfig) {
        this.transaction = transaction;
        this.statementConfig = statementConfig;
    }

    public Record getSingleResult(String statement, Value parameters) {
        try {
            return this.getSingleResult(this.execute(statement, parameters.asMap()));
        }
        catch (Neo4jException e) {
            throw new XOException("Cannot get result for statement '" + statement + "', " + parameters.asMap(), (Throwable)e);
        }
    }

    public Result execute(String statement, Value parameters) {
        return this.execute(statement, parameters.asMap());
    }

    public Result execute(String statement, Map<String, Object> parameters) {
        LogLevel statementLogger = this.statementConfig.getLogLevel();
        if (!LogLevel.NONE.equals((Object)statementLogger)) {
            statementLogger.log(LOGGER, "'" + statement + "': " + parameters);
        }
        try {
            QueryRunner queryRunner = this.transaction.getQueryRunner();
            return queryRunner.run(statement, parameters);
        }
        catch (Neo4jException e) {
            throw new XOException("Cannot execute statement '" + statement + "', " + parameters, (Throwable)e);
        }
    }

    private Record getSingleResult(Result result) {
        try {
            Record record = result.single();
            return record;
        }
        catch (NoSuchRecordException e) {
            throw new XOException("Query returned no result.");
        }
        finally {
            result.consume();
        }
    }
}

