/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.model;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.api.model.Neo4jNode;
import com.buschmais.xo.neo4j.remote.impl.model.AbstractRemotePropertyContainer;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteDirection;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteLabel;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteRelationship;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteRelationshipType;
import com.buschmais.xo.neo4j.remote.impl.model.state.NodeState;
import java.util.Set;

public class RemoteNode
extends AbstractRemotePropertyContainer<NodeState>
implements Neo4jNode<RemoteLabel, RemoteRelationship, RemoteRelationshipType, RemoteDirection> {
    public RemoteNode(long id, NodeState initialState) {
        super(id, initialState);
    }

    public Iterable<RemoteRelationship> getRelationships(RemoteRelationshipType type, RemoteDirection dir) {
        NodeState state = (NodeState)this.getState();
        switch (dir) {
            case OUTGOING: {
                return state.getOutgoingRelationships(type).getElements();
            }
            case INCOMING: {
                return state.getIncomingRelationships(type).getElements();
            }
        }
        throw new XOException("Unsupported direction " + dir);
    }

    public boolean hasRelationship(RemoteRelationshipType type, RemoteDirection dir) {
        return this.getRelationships(type, dir).iterator().hasNext();
    }

    public RemoteRelationship getSingleRelationship(RemoteRelationshipType type, RemoteDirection dir) {
        return this.getRelationships(type, dir).iterator().next();
    }

    public Set<RemoteLabel> getLabels() {
        return ((NodeState)this.getState()).getLabels().getElements();
    }
}

