/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.datastore;

import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.neo4j.api.annotation.Cypher;
import com.buschmais.xo.neo4j.remote.impl.datastore.StatementExecutor;
import com.buschmais.xo.neo4j.spi.CypherQuery;
import com.buschmais.xo.neo4j.spi.CypherQueryResultIterator;
import com.buschmais.xo.neo4j.spi.Notification;
import com.buschmais.xo.neo4j.spi.helper.Converter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.summary.ResultSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteCypherQuery
implements CypherQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteCypherQuery.class);
    private final StatementExecutor statementExecutor;
    private final Converter parameterConverter;
    private final Converter valueConverter;

    public RemoteCypherQuery(StatementExecutor statementExecutor, Converter parameterConverter, Converter valueConverter) {
        this.statementExecutor = statementExecutor;
        this.parameterConverter = parameterConverter;
        this.valueConverter = valueConverter;
    }

    public ResultIterator<Map<String, Object>> execute(Cypher query, Map<String, Object> parameters) {
        return this.execute(query.value(), parameters);
    }

    public ResultIterator<Map<String, Object>> execute(String query, Map<String, Object> parameters) {
        final Result result = this.statementExecutor.execute(query, (Map)this.parameterConverter.convert(parameters));
        return new CypherQueryResultIterator(){

            protected Logger getLogger() {
                return log;
            }

            public boolean hasNext() {
                return result.hasNext();
            }

            public Map<String, Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Record record = result.next();
                Map row = record.asMap();
                LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>(row.size(), 1.0f);
                for (Map.Entry entry : row.entrySet()) {
                    String column = (String)entry.getKey();
                    Object value = entry.getValue();
                    result2.put(column, RemoteCypherQuery.this.valueConverter.convert(value));
                }
                return result2;
            }

            public Iterable<Notification> dispose() {
                ResultSummary resultSummary = result.consume();
                return resultSummary.notifications().stream().map(n -> Notification.builder().title(n.title()).description(n.description()).code(n.code()).severity(Notification.Severity.from((String)n.severity())).offset(n.position().offset()).line(n.position().line()).column(n.position().column()).build()).collect(Collectors.toList());
            }
        };
    }
}

