/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.datastore;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.neo4j.remote.api.RemoteNeo4jXOProvider;
import com.buschmais.xo.neo4j.remote.impl.datastore.RemoteDatastoreSession;
import com.buschmais.xo.neo4j.remote.impl.datastore.StatementConfig;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteLabel;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteRelationshipType;
import com.buschmais.xo.neo4j.spi.AbstractNeo4jDatastore;
import com.buschmais.xo.neo4j.spi.AbstractNeo4jMetadataFactory;
import com.buschmais.xo.neo4j.spi.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.spi.metadata.RelationshipMetadata;
import com.buschmais.xo.spi.datastore.DatastoreMetadataFactory;
import com.buschmais.xo.spi.logging.LogLevel;
import com.google.common.base.CaseFormat;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDatastore
extends AbstractNeo4jDatastore<RemoteLabel, RemoteRelationshipType, RemoteDatastoreSession> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDatastore.class);
    private final Driver driver;
    private final StatementConfig statementConfig;

    public RemoteDatastore(XOUnit xoUnit) {
        URI uri = xoUnit.getUri();
        Properties properties = xoUnit.getProperties();
        this.driver = this.getDriver(uri, properties);
        this.statementConfig = this.getStatementConfig(properties);
    }

    private Driver getDriver(URI uri, Properties properties) {
        String username = RemoteNeo4jXOProvider.Property.USERNAME.get(properties);
        String password = RemoteNeo4jXOProvider.Property.PASSWORD.get(properties);
        String encryption = RemoteNeo4jXOProvider.Property.ENCRYPTION.get(properties);
        String trustStrategy = RemoteNeo4jXOProvider.Property.TRUST_STRATEGY.get(properties);
        String trustCertificate = RemoteNeo4jXOProvider.Property.TRUST_CERTIFICATE.get(properties);
        Config.ConfigBuilder configBuilder = Config.builder();
        if (encryption == null || Boolean.parseBoolean(encryption)) {
            configBuilder.withEncryption();
        }
        if (trustStrategy != null) {
            switch (this.getEnumOption(Config.TrustStrategy.Strategy.class, trustStrategy)) {
                case TRUST_ALL_CERTIFICATES: {
                    configBuilder.withTrustStrategy(Config.TrustStrategy.trustAllCertificates());
                    break;
                }
                case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: {
                    configBuilder.withTrustStrategy(Config.TrustStrategy.trustCustomCertificateSignedBy((File[])new File[]{new File(trustCertificate)}));
                    break;
                }
                case TRUST_SYSTEM_CA_SIGNED_CERTIFICATES: {
                    configBuilder.withTrustStrategy(Config.TrustStrategy.trustSystemCertificates());
                    break;
                }
                default: {
                    throw new XOException("Trust strategy not supported: " + trustStrategy);
                }
            }
        }
        AuthToken authToken = username != null ? AuthTokens.basic((String)username, (String)password) : null;
        return GraphDatabase.driver((URI)uri, (AuthToken)authToken, (Config)configBuilder.build());
    }

    private StatementConfig getStatementConfig(Properties properties) {
        String batchableDefault;
        StatementConfig.StatementConfigBuilder statementConfigBuilder = StatementConfig.builder();
        String statementLogLevel = RemoteNeo4jXOProvider.Property.STATEMENT_LOG_LEVEL.get(properties);
        if (statementLogLevel != null) {
            statementConfigBuilder.logLevel(this.getEnumOption(LogLevel.class, statementLogLevel));
        }
        if ((batchableDefault = RemoteNeo4jXOProvider.Property.STATEMENT_BATCHABLE_DEFAULT.get(properties)) != null) {
            statementConfigBuilder.batchableDefault(Boolean.parseBoolean(batchableDefault));
        }
        StatementConfig config = statementConfigBuilder.build();
        LOGGER.debug("Using statement configuration {}.", (Object)config);
        return config;
    }

    public DatastoreMetadataFactory<NodeMetadata<RemoteLabel>, RemoteLabel, RelationshipMetadata<RemoteRelationshipType>, RemoteRelationshipType> getMetadataFactory() {
        return new AbstractNeo4jMetadataFactory<RemoteLabel, RemoteRelationshipType>(){

            protected RemoteRelationshipType createRelationshipType(String name) {
                return new RemoteRelationshipType(name);
            }

            protected RemoteLabel createLabel(String name) {
                return new RemoteLabel(name);
            }

            protected boolean isBatchableDefault() {
                return RemoteDatastore.this.statementConfig.isBatchableDefault();
            }
        };
    }

    public RemoteDatastoreSession createSession() {
        Session session = this.driver.session();
        return new RemoteDatastoreSession(session, this.statementConfig);
    }

    public void close() {
        this.driver.close();
    }

    private <E extends Enum<E>> E getEnumOption(Class<E> enumType, String value) {
        String normalizedValue = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value);
        try {
            return Enum.valueOf(enumType, normalizedValue);
        }
        catch (IllegalArgumentException e) {
            ArrayList<String> allowedValues = new ArrayList<String>();
            for (Enum allowedValue : (Enum[])enumType.getEnumConstants()) {
                allowedValues.add(CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, allowedValue.name()));
            }
            throw new XOException("Unknown value '" + value + "', allowed values are " + allowedValues);
        }
    }
}

