/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.model;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.api.model.Neo4jPropertyContainer;
import com.buschmais.xo.neo4j.remote.impl.model.state.AbstractPropertyContainerState;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;

public abstract class AbstractRemotePropertyContainer<S extends AbstractPropertyContainerState>
implements Neo4jPropertyContainer {
    private final S state;
    private final long initialId;
    private long id;

    protected AbstractRemotePropertyContainer(long id, S state) {
        this.initialId = id;
        this.id = id;
        this.state = state;
    }

    public long getId() {
        return this.id;
    }

    public void updateId(Long id) {
        if (this.id >= 0L) {
            throw new XOException("Cannot update persistent id of " + this);
        }
        this.id = id;
    }

    public S getState() {
        return this.state;
    }

    public boolean hasProperty(String key) {
        return ((AbstractPropertyContainerState)this.state).getReadCache().containsKey(key);
    }

    public Object getProperty(String key) {
        return ((AbstractPropertyContainerState)this.state).getReadCache().get(key);
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(((AbstractPropertyContainerState)this.state).getReadCache());
    }

    public void setProperty(String key, Object value) {
        Object existingValue = this.getProperty(key);
        if (existingValue == null && value != null || existingValue != null && !existingValue.equals(value)) {
            ((AbstractPropertyContainerState)this.state).getOrCreateWriteCache().put(key, value);
            ((AbstractPropertyContainerState)this.state).getReadCache().put(key, value);
        }
    }

    public void removeProperty(String name) {
        this.setProperty(name, null);
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && other.getClass().equals(this.getClass())) {
            AbstractRemotePropertyContainer otherContainer = (AbstractRemotePropertyContainer)other;
            return this.id == otherContainer.id || this.id == otherContainer.initialId || this.initialId == otherContainer.id;
        }
        return false;
    }

    public final int hashCode() {
        return (int)this.initialId;
    }

    @Generated
    public String toString() {
        return "AbstractRemotePropertyContainer(state=" + this.getState() + ", initialId=" + this.initialId + ", id=" + this.getId() + ")";
    }
}

