/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.spi;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.metadata.method.IndexedPropertyMethodMetadata;
import com.buschmais.xo.api.metadata.reflection.AnnotatedElement;
import com.buschmais.xo.api.metadata.reflection.AnnotatedMethod;
import com.buschmais.xo.api.metadata.reflection.AnnotatedType;
import com.buschmais.xo.api.metadata.reflection.PropertyMethod;
import com.buschmais.xo.api.metadata.type.TypeMetadata;
import com.buschmais.xo.neo4j.api.annotation.Batchable;
import com.buschmais.xo.neo4j.api.annotation.Label;
import com.buschmais.xo.neo4j.api.annotation.Property;
import com.buschmais.xo.neo4j.api.annotation.Relation;
import com.buschmais.xo.neo4j.api.model.Neo4jLabel;
import com.buschmais.xo.neo4j.api.model.Neo4jRelationshipType;
import com.buschmais.xo.neo4j.spi.metadata.IndexedPropertyMetadata;
import com.buschmais.xo.neo4j.spi.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.spi.metadata.PropertyMetadata;
import com.buschmais.xo.neo4j.spi.metadata.RelationshipMetadata;
import com.buschmais.xo.spi.datastore.DatastoreMetadataFactory;
import com.google.common.base.CaseFormat;
import java.util.List;
import java.util.Map;

public abstract class AbstractNeo4jMetadataFactory<L extends Neo4jLabel, R extends Neo4jRelationshipType>
implements DatastoreMetadataFactory<NodeMetadata<L>, L, RelationshipMetadata<R>, R> {
    public NodeMetadata createEntityMetadata(AnnotatedType annotatedType, List<TypeMetadata> superTypes, Map<Class<?>, TypeMetadata> metadataByType) {
        Label labelAnnotation = (Label)annotatedType.getAnnotation(Label.class);
        Object label = null;
        IndexedPropertyMethodMetadata indexedProperty = null;
        if (labelAnnotation != null) {
            String value = labelAnnotation.value();
            if ("".equals(value)) {
                value = annotatedType.getName();
            }
            label = this.createLabel(value);
            Class usingIndexOf = labelAnnotation.usingIndexedPropertyOf();
            if (!Object.class.equals((Object)usingIndexOf)) {
                TypeMetadata typeMetadata = metadataByType.get(usingIndexOf);
                indexedProperty = typeMetadata.getIndexedProperty();
            }
        }
        boolean batchable = this.isBatchable((AnnotatedElement<?>)annotatedType);
        return new NodeMetadata<Object>(label, (IndexedPropertyMethodMetadata<IndexedPropertyMetadata>)indexedProperty, batchable);
    }

    public <ImplementedByMetadata> ImplementedByMetadata createImplementedByMetadata(AnnotatedMethod annotatedMethod) {
        return null;
    }

    public <CollectionPropertyMetadata> CollectionPropertyMetadata createCollectionPropertyMetadata(PropertyMethod propertyMethod) {
        return null;
    }

    public <ReferencePropertyMetadata> ReferencePropertyMetadata createReferencePropertyMetadata(PropertyMethod propertyMethod) {
        return null;
    }

    public PropertyMetadata createPropertyMetadata(PropertyMethod propertyMethod) {
        Property property = (Property)propertyMethod.getAnnotation(Property.class);
        String name = property != null ? property.value() : propertyMethod.getName();
        return new PropertyMetadata(name);
    }

    public IndexedPropertyMetadata createIndexedPropertyMetadata(PropertyMethod propertyMethod) {
        return new IndexedPropertyMetadata();
    }

    public RelationshipMetadata<R> createRelationMetadata(AnnotatedElement<?> annotatedElement, Map<Class<?>, TypeMetadata> metadataByType) {
        String value;
        boolean batchable;
        Relation relationAnnotation;
        if (annotatedElement instanceof PropertyMethod) {
            relationAnnotation = (Relation)annotatedElement.getAnnotation(Relation.class);
            batchable = true;
        } else if (annotatedElement instanceof AnnotatedType) {
            AnnotatedType annotatedType = (AnnotatedType)annotatedElement;
            relationAnnotation = (Relation)annotatedType.getAnnotation(Relation.class);
            batchable = ((Class)annotatedType.getAnnotatedElement()).isAnnotation() || this.isBatchable(annotatedElement);
        } else {
            throw new XOException("Annotated element is not supported: " + annotatedElement);
        }
        String name = null;
        if (relationAnnotation != null && !"".equals(value = relationAnnotation.value())) {
            name = value;
        }
        if (name == null) {
            name = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, annotatedElement.getName());
        }
        return new RelationshipMetadata<R>(this.createRelationshipType(name), batchable);
    }

    private boolean isBatchable(AnnotatedElement<?> annotatedElement) {
        Batchable batchable = (Batchable)annotatedElement.getAnnotation(Batchable.class);
        return batchable != null ? batchable.value() : this.isBatchableDefault();
    }

    protected abstract R createRelationshipType(String var1);

    protected abstract L createLabel(String var1);

    protected abstract boolean isBatchableDefault();
}

