/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.spi;

import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.api.annotation.Cypher;
import com.buschmais.xo.neo4j.api.model.Neo4jLabel;
import com.buschmais.xo.neo4j.api.model.Neo4jNode;
import com.buschmais.xo.neo4j.api.model.Neo4jRelationship;
import com.buschmais.xo.neo4j.api.model.Neo4jRelationshipType;
import com.buschmais.xo.neo4j.spi.Neo4jDatastoreSession;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNeo4jDatastoreSession<N extends Neo4jNode, L extends Neo4jLabel, R extends Neo4jRelationship, T extends Neo4jRelationshipType>
implements Neo4jDatastoreSession<N, L, R, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNeo4jDatastoreSession.class);

    @Override
    public Set<Neo4jDatastoreSession.Index> getIndexes() {
        return this.getIndexes("labelsOrTypes", "properties");
    }

    @Override
    public void createIndexes(Set<Neo4jDatastoreSession.Index> indexes) {
        LOGGER.debug("Creating indexes {}.", indexes);
        for (Neo4jDatastoreSession.Index index : indexes) {
            String statement = String.format("CREATE INDEX ON :%s(%s)", index.getLabels().stream().collect(Collectors.joining(":")), index.getProperties().stream().collect(Collectors.joining(",")));
            ResultIterator iterator = this.createQuery(Cypher.class).execute(statement, Collections.emptyMap());
            try {
                while (iterator.hasNext()) {
                }
            }
            finally {
                if (iterator == null) continue;
                iterator.close();
            }
        }
    }

    public String getNeo4jVersion() {
        try (ResultIterator iterator = this.createQuery(Cypher.class).execute("CALL dbms.components() YIELD versions UNWIND versions AS version RETURN version", Collections.emptyMap());){
            if (iterator.hasNext()) {
                Map row = (Map)iterator.next();
                String string = (String)row.get("version");
                return string;
            }
        }
        throw new XOException("Cannot determine Neo4j version.");
    }

    private Set<Neo4jDatastoreSession.Index> getIndexes(String labelsColumn, String propertiesColumn) {
        HashSet<Neo4jDatastoreSession.Index> indexes = new HashSet<Neo4jDatastoreSession.Index>();
        String query = String.format("CALL db.indexes() YIELD %s AS labels, %s AS properties RETURN labels, properties", labelsColumn, propertiesColumn);
        try (ResultIterator iterator = this.createQuery(Cypher.class).execute(query, Collections.emptyMap());){
            while (iterator.hasNext()) {
                Map row = (Map)iterator.next();
                List labels = (List)row.get("labels");
                List properties = (List)row.get("properties");
                indexes.add(Neo4jDatastoreSession.Index.builder().labels(labels).properties(properties).build());
            }
        }
        return indexes;
    }
}

