/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.spi;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Notification {
    Severity severity;
    String code;
    String title;
    String description;
    int offset;
    int line;
    int column;

    @Generated
    Notification(Severity severity, String code, String title, String description, int offset, int line, int column) {
        this.severity = severity;
        this.code = code;
        this.title = title;
        this.description = description;
        this.offset = offset;
        this.line = line;
        this.column = column;
    }

    @Generated
    public static NotificationBuilder builder() {
        return new NotificationBuilder();
    }

    @Generated
    public Severity getSeverity() {
        return this.severity;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Generated
    public int getLine() {
        return this.line;
    }

    @Generated
    public int getColumn() {
        return this.column;
    }

    @Generated
    public String toString() {
        return "Notification(severity=" + this.getSeverity() + ", code=" + this.getCode() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", offset=" + this.getOffset() + ", line=" + this.getLine() + ", column=" + this.getColumn() + ")";
    }

    public static enum Severity {
        WARNING,
        INFORMATION;

        @Generated
        private static final Logger log;
        private static final Map<String, Severity> VALUES;

        public static Severity from(String name) {
            if (name == null) {
                return WARNING;
            }
            Severity severity = VALUES.get(name.toUpperCase());
            if (severity != null) {
                return severity;
            }
            log.warn("Unknown notification severity '{}', falling back to '{}'.", (Object)name, (Object)WARNING);
            return WARNING;
        }

        static {
            log = LoggerFactory.getLogger(Severity.class);
            VALUES = Arrays.stream(Severity.values()).collect(Collectors.toMap(value -> value.name().toUpperCase(), value -> value));
        }
    }

    @Generated
    public static class NotificationBuilder {
        @Generated
        private Severity severity;
        @Generated
        private String code;
        @Generated
        private String title;
        @Generated
        private String description;
        @Generated
        private int offset;
        @Generated
        private int line;
        @Generated
        private int column;

        @Generated
        NotificationBuilder() {
        }

        @Generated
        public NotificationBuilder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        @Generated
        public NotificationBuilder code(String code) {
            this.code = code;
            return this;
        }

        @Generated
        public NotificationBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public NotificationBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public NotificationBuilder offset(int offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public NotificationBuilder line(int line) {
            this.line = line;
            return this;
        }

        @Generated
        public NotificationBuilder column(int column) {
            this.column = column;
            return this;
        }

        @Generated
        public Notification build() {
            return new Notification(this.severity, this.code, this.title, this.description, this.offset, this.line, this.column);
        }

        @Generated
        public String toString() {
            return "Notification.NotificationBuilder(severity=" + this.severity + ", code=" + this.code + ", title=" + this.title + ", description=" + this.description + ", offset=" + this.offset + ", line=" + this.line + ", column=" + this.column + ")";
        }
    }
}

