/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.spi;

import com.buschmais.xo.neo4j.api.model.Neo4jLabel;
import com.buschmais.xo.neo4j.api.model.Neo4jNode;
import com.buschmais.xo.neo4j.api.model.Neo4jRelationship;
import com.buschmais.xo.neo4j.api.model.Neo4jRelationshipType;
import com.buschmais.xo.neo4j.spi.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.spi.metadata.PropertyMetadata;
import com.buschmais.xo.neo4j.spi.metadata.RelationshipMetadata;
import com.buschmais.xo.spi.datastore.DatastoreSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;

public interface Neo4jDatastoreSession<N extends Neo4jNode, L extends Neo4jLabel, R extends Neo4jRelationship, T extends Neo4jRelationshipType>
extends DatastoreSession<Long, N, NodeMetadata<L>, L, Long, R, RelationshipMetadata<T>, T, PropertyMetadata> {
    public String getNeo4jVersion();

    public Object convertValue(Object var1);

    public Object convertParameter(Object var1);

    public Set<Index> getIndexes();

    public void createIndexes(Set<Index> var1);

    public static class Index {
        private final Set<String> labels;
        private final Set<String> properties;

        @Generated
        Index(Set<String> labels, Set<String> properties) {
            this.labels = labels;
            this.properties = properties;
        }

        @Generated
        public static IndexBuilder builder() {
            return new IndexBuilder();
        }

        @Generated
        public Set<String> getLabels() {
            return this.labels;
        }

        @Generated
        public Set<String> getProperties() {
            return this.properties;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Index)) {
                return false;
            }
            Index other = (Index)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$labels = this.getLabels();
            Set<String> other$labels = other.getLabels();
            if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
                return false;
            }
            Set<String> this$properties = this.getProperties();
            Set<String> other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Index;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $labels = this.getLabels();
            result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
            Set<String> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Neo4jDatastoreSession.Index(labels=" + this.getLabels() + ", properties=" + this.getProperties() + ")";
        }

        @Generated
        public static class IndexBuilder {
            @Generated
            private ArrayList<String> labels;
            @Generated
            private ArrayList<String> properties;

            @Generated
            IndexBuilder() {
            }

            @Generated
            public IndexBuilder label(String label) {
                if (this.labels == null) {
                    this.labels = new ArrayList();
                }
                this.labels.add(label);
                return this;
            }

            @Generated
            public IndexBuilder labels(Collection<? extends String> labels) {
                if (labels == null) {
                    throw new NullPointerException("labels cannot be null");
                }
                if (this.labels == null) {
                    this.labels = new ArrayList();
                }
                this.labels.addAll(labels);
                return this;
            }

            @Generated
            public IndexBuilder clearLabels() {
                if (this.labels != null) {
                    this.labels.clear();
                }
                return this;
            }

            @Generated
            public IndexBuilder property(String property) {
                if (this.properties == null) {
                    this.properties = new ArrayList();
                }
                this.properties.add(property);
                return this;
            }

            @Generated
            public IndexBuilder properties(Collection<? extends String> properties) {
                if (properties == null) {
                    throw new NullPointerException("properties cannot be null");
                }
                if (this.properties == null) {
                    this.properties = new ArrayList();
                }
                this.properties.addAll(properties);
                return this;
            }

            @Generated
            public IndexBuilder clearProperties() {
                if (this.properties != null) {
                    this.properties.clear();
                }
                return this;
            }

            @Generated
            public Index build() {
                Set<String> properties;
                Set<Object> labels;
                switch (this.labels == null ? 0 : this.labels.size()) {
                    case 0: {
                        labels = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        labels = Collections.singleton(this.labels.get(0));
                        break;
                    }
                    default: {
                        labels = new LinkedHashSet(this.labels.size() < 0x40000000 ? 1 + this.labels.size() + (this.labels.size() - 3) / 3 : Integer.MAX_VALUE);
                        labels.addAll(this.labels);
                        labels = Collections.unmodifiableSet(labels);
                    }
                }
                switch (this.properties == null ? 0 : this.properties.size()) {
                    case 0: {
                        properties = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        properties = Collections.singleton(this.properties.get(0));
                        break;
                    }
                    default: {
                        properties = new LinkedHashSet<String>(this.properties.size() < 0x40000000 ? 1 + this.properties.size() + (this.properties.size() - 3) / 3 : Integer.MAX_VALUE);
                        properties.addAll(this.properties);
                        properties = Collections.unmodifiableSet(properties);
                    }
                }
                return new Index(labels, properties);
            }

            @Generated
            public String toString() {
                return "Neo4jDatastoreSession.Index.IndexBuilder(labels=" + this.labels + ", properties=" + this.properties + ")";
            }
        }
    }
}

