/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.spi.reflection;

import com.buschmais.xo.api.XOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;

public final class ClassHelper {
    private ClassHelper() {
    }

    public static <T> Class<T> getType(String name) {
        Class<?> type;
        try {
            type = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new XOException("Cannot find class with name '" + name + "'", (Throwable)e);
        }
        return type;
    }

    public static Collection<Class<?>> getTypes(Collection<String> typeNames) {
        HashSet types = new HashSet();
        for (String typeName : typeNames) {
            types.add(ClassHelper.getType(typeName));
        }
        return types;
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw new XOException("Cannot create instance of type '" + type.getName() + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new XOException("Access denied to type '" + type.getName() + "'", (Throwable)e);
        }
    }

    public static Class<?> getTypeParameter(Class<?> genericType, Class<?> type) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = type.getGenericInterfaces()) {
            Type typeParameter;
            ParameterizedType parameterizedType;
            if (!(genericInterface instanceof ParameterizedType) || !genericType.equals((parameterizedType = (ParameterizedType)genericInterface).getRawType()) || !((typeParameter = ((ParameterizedType)genericInterface).getActualTypeArguments()[0]) instanceof Class)) continue;
            return (Class)typeParameter;
        }
        return null;
    }
}

