/*
 * Decompiled with CFR 0.152.
 */
package busymachines.future;

import busymachines.core.Anomaly;
import busymachines.core.CatastrophicError$;
import busymachines.future.package$;
import busymachines.result.Correct$;
import busymachines.result.Incorrect$;
import busymachines.result.Result$;
import cats.effect.IO;
import cats.effect.IO$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class FutureUtil$ {
    public static FutureUtil$ MODULE$;
    private final Function1<Object, BoxedUnit> UnitFunction;
    private volatile boolean bitmap$init$0;

    static {
        new FutureUtil$();
    }

    public <T> Future<T> pure(T t) {
        return package$.MODULE$.Future().successful(t);
    }

    public <T> Future<T> fail(Anomaly a) {
        return package$.MODULE$.Future().failed(a.asThrowable());
    }

    public <R> Future<R> fromResult(Either<Anomaly, R> r) {
        return Result$.MODULE$.asFuture(r);
    }

    public <T> Future<T> resultFlatten(Future<Either<Anomaly, T>> fres, ExecutionContext ec) {
        return fres.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            Option option;
            Object object;
            Right right;
            Option option2;
            Either either = x0$1;
            if (either instanceof Right && !(option2 = Correct$.MODULE$.unapply(right = (Right)either)).isEmpty()) {
                Object c = option2.get();
                object = MODULE$.pure(c);
            } else if (either instanceof Left && !(option = Incorrect$.MODULE$.unapply(left = (Left)either)).isEmpty()) {
                Anomaly a = (Anomaly)option.get();
                object = MODULE$.fail(a);
            } else {
                throw new MatchError((Object)either);
            }
            return object;
        }, ec);
    }

    public <L, R> Future<R> fromEither(Either<L, R> elr, Predef$.less.colon.less<L, Throwable> ev) {
        Object object;
        Either<L, R> either = elr;
        if (either instanceof Left) {
            Future future;
            Left left = (Left)either;
            Object left2 = left.value();
            Throwable throwable = (Throwable)ev.apply(left2);
            if (throwable instanceof Anomaly) {
                Throwable throwable2 = throwable;
                future = this.fail((Anomaly)throwable2);
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    future = this.fail((Anomaly)CatastrophicError$.MODULE$.apply(t));
                } else {
                    throw new MatchError((Object)throwable);
                }
            }
            object = future;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object value = right.value();
            object = this.pure(value);
        } else {
            throw new MatchError(either);
        }
        return object;
    }

    public <L, R> Future<R> fromEither(Either<L, R> elr, Function1<L, Anomaly> transformLeft) {
        Object object;
        Either<L, R> either = elr;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object left2 = left.value();
            object = this.fail((Anomaly)transformLeft.apply(left2));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object value = right.value();
            object = this.pure(value);
        } else {
            throw new MatchError(either);
        }
        return object;
    }

    public <T> Future<T> fromOption(Option<T> opt, Function0<Anomaly> ifNone) {
        Object object;
        Option<T> option = opt;
        if (None$.MODULE$.equals(option)) {
            object = this.fail((Anomaly)ifNone.apply());
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Object v = some.value();
            object = this.pure(v);
        } else {
            throw new MatchError(option);
        }
        return object;
    }

    public <T> Future<T> optionFlatten(Future<Option<T>> fopt, Function0<Anomaly> ifNone, ExecutionContext ec) {
        return fopt.flatMap((Function1 & Serializable & scala.Serializable)opt -> MODULE$.fromOption((Option)opt, ifNone), ec);
    }

    public <T> Future<T> cond(boolean test, Function0<T> correct, Function0<Anomaly> anomaly) {
        return test ? this.pure(correct.apply()) : this.fail((Anomaly)anomaly.apply());
    }

    public <T> Future<T> condWith(boolean test, Function0<Future<T>> correct, Function0<Anomaly> anomaly) {
        return test ? (Future<T>)correct.apply() : this.fail((Anomaly)anomaly.apply());
    }

    public Future<BoxedUnit> failOnTrue(boolean test, Function0<Anomaly> anomaly) {
        return test ? this.fail((Anomaly)anomaly.apply()) : package$.MODULE$.Future().unit();
    }

    public Future<BoxedUnit> failOnFalse(boolean test, Function0<Anomaly> anomaly) {
        return !test ? this.fail((Anomaly)anomaly.apply()) : package$.MODULE$.Future().unit();
    }

    public <T> Future<T> flatCond(Future<Object> test, Function0<T> correct, Function0<Anomaly> anomaly, ExecutionContext ec) {
        return test.flatMap((Function1 & Serializable & scala.Serializable)b -> FutureUtil$.MODULE$.cond(BoxesRunTime.unboxToBoolean((Object)b), correct, (Function0<Anomaly>)anomaly), ec);
    }

    public <T> Future<T> flatCondWith(Future<Object> test, Function0<Future<T>> correct, Function0<Anomaly> anomaly, ExecutionContext ec) {
        return test.flatMap((Function1 & Serializable & scala.Serializable)b -> FutureUtil$.MODULE$.condWith(BoxesRunTime.unboxToBoolean((Object)b), correct, (Function0<Anomaly>)anomaly), ec);
    }

    public Future<BoxedUnit> flatFailOnTrue(Future<Object> test, Function0<Anomaly> anomaly, ExecutionContext ec) {
        return test.flatMap((Function1 & Serializable & scala.Serializable)b -> FutureUtil$.$anonfun$flatFailOnTrue$1(anomaly, BoxesRunTime.unboxToBoolean((Object)b)), ec);
    }

    public Future<BoxedUnit> flatFailOnFalse(Future<Object> test, Function0<Anomaly> anomaly, ExecutionContext ec) {
        return test.flatMap((Function1 & Serializable & scala.Serializable)b -> FutureUtil$.$anonfun$flatFailOnFalse$1(anomaly, BoxesRunTime.unboxToBoolean((Object)b)), ec);
    }

    public <T> Future<BoxedUnit> effectOnTrue(boolean test, Function0<Future<T>> eff, ExecutionContext ec) {
        return test ? this.asUnitFuture((Future)eff.apply(), ec) : package$.MODULE$.Future().unit();
    }

    public <T> Future<BoxedUnit> effectOnFalse(boolean test, Function0<Future<T>> eff, ExecutionContext ec) {
        return !test ? this.asUnitFuture((Future)eff.apply(), ec) : package$.MODULE$.Future().unit();
    }

    public <T> Future<BoxedUnit> flatEffectOnTrue(Future<Object> test, Function0<Future<T>> eff, ExecutionContext ec) {
        return test.flatMap((Function1 & Serializable & scala.Serializable)b -> FutureUtil$.$anonfun$flatEffectOnTrue$1(eff, ec, BoxesRunTime.unboxToBoolean((Object)b)), ec);
    }

    public <T> Future<BoxedUnit> flatEffectOnFalse(Future<Object> test, Function0<Future<T>> eff, ExecutionContext ec) {
        return test.flatMap((Function1 & Serializable & scala.Serializable)b -> FutureUtil$.$anonfun$flatEffectOnFalse$1(eff, ec, BoxesRunTime.unboxToBoolean((Object)b)), ec);
    }

    private Function1<Object, BoxedUnit> UnitFunction() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/lorandszakacs/workspace/bm/busymachines-commons/future/src/main/scala/busymachines/future/FutureUtil.scala: 113");
        }
        return this.UnitFunction;
    }

    public <T> Future<BoxedUnit> asUnitFuture(Future<T> f, ExecutionContext ec) {
        return f.map(this.UnitFunction(), ec);
    }

    public <T> IO<T> asIO(Function0<Future<T>> f, ExecutionContext ec) {
        return IO$.MODULE$.fromFuture(IO$.MODULE$.apply(f), ec);
    }

    public <T> Future<Either<Anomaly, T>> asResult(Future<T> f, ExecutionContext ec) {
        return this.morph(f, (Function1 & Serializable & scala.Serializable)t -> {
            Either either;
            Throwable throwable = t;
            if (throwable instanceof Anomaly) {
                Throwable throwable2 = throwable;
                either = Result$.MODULE$.fail((Anomaly)throwable2);
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    either = Result$.MODULE$.fail((Anomaly)CatastrophicError$.MODULE$.apply(e));
                } else {
                    throw new MatchError((Object)throwable);
                }
            }
            return either;
        }, (Function1 & Serializable & scala.Serializable)v -> Result$.MODULE$.pure(v), ec);
    }

    public <T> T syncUnsafeGet(Future<T> f, FiniteDuration timeout) {
        return (T)package$.MODULE$.Await().result(f, (Duration)timeout);
    }

    public <T> FiniteDuration syncUnsafeGet$default$2() {
        return busymachines.duration.package$.MODULE$.minutes(1L);
    }

    public <T> Future<T> syncAwaitReady(Future<T> f, FiniteDuration timeout) {
        return (Future)package$.MODULE$.Await().ready(f, (Duration)timeout);
    }

    public <T> FiniteDuration syncAwaitReady$default$2() {
        return busymachines.duration.package$.MODULE$.minutes(1L);
    }

    public <T> Either<Anomaly, T> syncAsResult(Future<T> f, FiniteDuration timeout) {
        return Result$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.syncUnsafeGet(f, timeout));
    }

    public <T> FiniteDuration syncAsResult$default$2() {
        return busymachines.duration.package$.MODULE$.minutes(1L);
    }

    public <T, R> Future<R> bimap(Future<T> f, Function1<T, R> good, Function1<Throwable, Throwable> bad, ExecutionContext ec) {
        return f.transform(good, bad, ec);
    }

    public <T, R> Future<R> morph(Future<T> f, Function1<Throwable, R> bad, Function1<T, R> good, ExecutionContext ec) {
        return f.transform((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Success success;
            Try try_ = x0$2;
            if (try_ instanceof Success) {
                Success success2 = (Success)try_;
                Object v = success2.value();
                success = new Success(good.apply(v));
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                success = new Success(bad.apply((Object)t));
            } else {
                throw new MatchError((Object)try_);
            }
            return success;
        }, ec);
    }

    public <T, R> Future<R> morph(Future<T> f, Function1<Either<Anomaly, T>, Either<Anomaly, R>> morphism, ExecutionContext ec) {
        return this.resultFlatten(this.asResult(f, ec).map(morphism, ec), ec);
    }

    public <A, B, C extends TraversableOnce<Object>> Future<C> serialize(C col, Function1<A, Future<B>> fn, CanBuildFrom<C, B, C> cbf, ExecutionContext ec) {
        Future future;
        if (col.isEmpty()) {
            future = package$.MODULE$.Future().successful(cbf.apply().result());
        } else {
            Seq seq = col.toSeq();
            Object head = seq.head();
            Seq tail = (Seq)seq.tail();
            Builder builder = cbf.apply();
            Future firstBuilder = ((Future)fn.apply(head)).map((Function1 & Serializable & scala.Serializable)z -> builder.$plus$eq(z), ec);
            Future eventualBuilder = (Future)tail.foldLeft((Object)firstBuilder, (Function2 & Serializable & scala.Serializable)(serializedBuilder, element) -> serializedBuilder.flatMap((Function1 & Serializable & scala.Serializable)result -> {
                Future f = ((Future)fn.apply(element)).map((Function1 & Serializable & scala.Serializable)newElement -> result.$plus$eq(newElement), ec);
                return f;
            }, ec));
            future = eventualBuilder.map((Function1 & Serializable & scala.Serializable)b -> (TraversableOnce)b.result(), ec);
        }
        return future;
    }

    public static final /* synthetic */ Future $anonfun$flatFailOnTrue$1(Function0 anomaly$3, boolean b) {
        return b ? MODULE$.fail((Anomaly)anomaly$3.apply()) : package$.MODULE$.Future().unit();
    }

    public static final /* synthetic */ Future $anonfun$flatFailOnFalse$1(Function0 anomaly$4, boolean b) {
        return !b ? MODULE$.fail((Anomaly)anomaly$4.apply()) : package$.MODULE$.Future().unit();
    }

    public static final /* synthetic */ Future $anonfun$flatEffectOnTrue$1(Function0 eff$1, ExecutionContext ec$1, boolean b) {
        return b ? MODULE$.asUnitFuture((Future)eff$1.apply(), ec$1) : package$.MODULE$.Future().unit();
    }

    public static final /* synthetic */ Future $anonfun$flatEffectOnFalse$1(Function0 eff$2, ExecutionContext ec$2, boolean b) {
        return !b ? MODULE$.asUnitFuture((Future)eff$2.apply(), ec$2) : package$.MODULE$.Future().unit();
    }

    public static final /* synthetic */ void $anonfun$UnitFunction$1(Object x$1) {
    }

    private FutureUtil$() {
        MODULE$ = this;
        this.UnitFunction = (Function1 & Serializable & scala.Serializable)x$1 -> {
            FutureUtil$.$anonfun$UnitFunction$1(x$1);
            return BoxedUnit.UNIT;
        };
        this.bitmap$init$0 = true;
    }
}

