/*
 * Decompiled with CFR 0.152.
 */
package org.butor.test;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.butor.json.CommonRequestArgs;
import org.butor.json.JsonHelper;
import org.butor.json.service.Context;
import org.butor.json.service.ResponseHandler;
import org.junit.Assert;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.jdbc.JdbcTestUtils;

public class ButorTestUtil {
    public Context context(final CommonRequestArgs commonRequestArgs, final ResponseHandler<Object> rh) {
        return new Context(){

            public ResponseHandler<Object> getResponseHandler() {
                return rh;
            }

            public CommonRequestArgs getRequest() {
                return commonRequestArgs;
            }
        };
    }

    public static CommonRequestArgs getCommonRequestArgs(String commonRequestJSON) {
        CommonRequestArgs commonRequestArgs = (CommonRequestArgs)new JsonHelper().deserialize(commonRequestJSON, CommonRequestArgs.class);
        return commonRequestArgs;
    }

    public void assertObjectEqual(Object expected, Object actual) {
        this.assertObjectEqual("", expected, actual);
    }

    public void assertObjectEqual(String message, Object expected, Object actual) {
        Map<String, Object> mapExpected = this.getFieldMap(expected);
        Map<String, Object> mapActualMap = this.getFieldMap(actual);
        for (Map.Entry<String, Object> entry : mapExpected.entrySet()) {
            Object actualValue = mapActualMap.get(entry.getKey());
            Object expectedValue = entry.getValue();
            Assert.assertEquals((String)String.format("Field differs : %s, %s\n", entry.getKey(), message), (Object)expectedValue, (Object)actualValue);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private Map<String, Object> getFieldMap(Object o1) {
        TreeMap<String, Object> mapObject1 = new TreeMap<String, Object>();
        for (Field f : o1.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            try {
                mapObject1.put(f.getName(), f.get(o1));
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return mapObject1;
    }

    public void executeSQL(JdbcTemplate jt, URL sqlURL, String dbName) throws IOException {
        this.executeSQL(jt, sqlURL, dbName, "derby");
    }

    public void executeSQL(JdbcTemplate jt, URL sqlURL, String dbName, String jdbcDriverType) throws IOException {
        String sql = this.getStringFromURL(sqlURL);
        this.executeSQL(jt, sql, dbName, jdbcDriverType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringFromURL(URL url) throws IOException {
        StringWriter sw = new StringWriter();
        InputStream is = null;
        try {
            int c;
            is = url.openStream();
            while ((c = is.read()) != -1) {
                sw.append((char)c);
            }
        }
        finally {
            Closeables.closeQuietly((InputStream)is);
        }
        return sw.toString();
    }

    public void executeSQL(JdbcTemplate jt, String sqlData, String dbName, String jdbcDriverType) throws IOException {
        Assert.assertNotNull((Object)jt);
        ArrayList scriptlines = new ArrayList();
        JdbcTestUtils.splitSqlScript((String)sqlData, (char)';', scriptlines);
        for (String sqlOri : scriptlines) {
            try {
                String trimmedSql = sqlOri.trim();
                if (trimmedSql.length() == 0) continue;
                if (jdbcDriverType.equals("derby")) {
                    if (trimmedSql.startsWith("DROP DATABASE") || trimmedSql.startsWith("ALTER TABLE")) continue;
                    String sql = sqlOri.replace("`", "");
                    sql = sql.replace("CREATE DATABASE IF NOT EXISTS " + dbName, "CREATE SCHEMA " + dbName);
                    sql = sql.replace("DROP TABLE IF EXISTS ", "DROP TABLE ");
                    sql = sql.replaceAll("comment '[^']*'", "");
                    sql = sql.replaceAll("unsigned", "");
                    sql = sql.replaceAll("TEXT", "CLOB");
                    sql = sql.replaceAll("(?i)NOT NULL", "NOT_NU__");
                    sql = sql.replace("NULL", "");
                    sql = sql.replaceAll("(?i)DATETIME", "TIMESTAMP");
                    sql = sql.replaceAll("(?i)NOW\\(\\)", "CURRENT_TIMESTAMP");
                    sql = sql.replaceAll("(?i)now", "CURRENT_TIMESTAMP");
                    sql = sql.replaceAll("NOT_NU__", "NOT NULL");
                    sql = sql.replaceAll("(?i)ENGINE = InnoDB", "");
                    sql = sql.replaceAll("(?i)AUTO_INCREMENT", "GENERATED BY DEFAULT AS IDENTITY");
                    System.out.println(sql);
                    jt.execute(sql);
                    continue;
                }
                System.out.println(sqlOri);
                jt.execute(sqlOri);
            }
            catch (Throwable e) {
                System.out.println("====> " + e.getMessage());
                if (!(e instanceof BadSqlGrammarException)) continue;
                String msg = ((BadSqlGrammarException)e).getSQLException().getMessage();
                Pattern ptr = Pattern.compile("^Table .* not found.*");
                if (msg.indexOf("because it does not exist") > -1 || ptr.matcher(msg).find() || msg.indexOf("object not found") > -1 || msg.indexOf("already exists") > -1) continue;
                Assert.fail((String)e.getMessage());
            }
        }
    }

    public static JsonHelper getJsonHelperWithLocalTimeFormatter() {
        return new JsonHelper("yyyy-MM-dd HH:mm:ss.SSS");
    }
}

