/*
 * Decompiled with CFR 0.152.
 */
package org.butor.checksum;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.butor.checksum.ChecksumFunction;

public enum CommonChecksumFunction implements ChecksumFunction
{
    MD5(Hashing.md5()),
    SHA1(Hashing.sha1()),
    SHA256(Hashing.sha256()),
    SHA512(Hashing.sha512());

    private final HashFunction hf;
    private final int checksumLengthWithoutTTL;
    private final int checksumLengthWithTTL;
    private static final Random random;

    private CommonChecksumFunction(HashFunction hf) {
        this.hf = hf;
        this.checksumLengthWithoutTTL = hf.bits() / 4 + 16;
        this.checksumLengthWithTTL = this.checksumLengthWithoutTTL + 16;
    }

    @Override
    public String generateChecksum(String object) {
        return this.generateChecksum(object, CommonChecksumFunction.createSalt(), Long.MAX_VALUE);
    }

    @Override
    public boolean validateChecksum(String object, String checksum) {
        String saltStr;
        boolean includeTTL;
        if (checksum == null || object == null) {
            return false;
        }
        if (checksum.length() == this.checksumLengthWithTTL) {
            includeTTL = true;
        } else if (checksum.length() == this.checksumLengthWithoutTTL) {
            includeTTL = false;
        } else {
            return false;
        }
        Long goodTill = Long.MAX_VALUE;
        if (includeTTL) {
            String timeStr = checksum.substring(0, 16);
            goodTill = Long.decode("0x" + timeStr);
            if (System.currentTimeMillis() > goodTill) {
                return false;
            }
            saltStr = checksum.substring(16, 32);
        } else {
            saltStr = checksum.substring(0, 16);
        }
        Long salt = Long.decode("0x" + saltStr);
        String hash = this.generateChecksum(object, salt, goodTill);
        return hash.equals(checksum);
    }

    @Override
    public String generateChecksumWithTTL(String object, long duration, TimeUnit unit) {
        return this.generateChecksum(object, CommonChecksumFunction.createSalt(), System.currentTimeMillis() + unit.toMillis(duration));
    }

    private String generateChecksum(String object, long salt, long maxTime) {
        Preconditions.checkNotNull((Object)object, (Object)"Cannot generate checksum for null objects");
        String saltStr = String.format("%16s", Long.toString(salt, 16)).replace(' ', '0');
        String timeStr = maxTime == Long.MAX_VALUE ? "" : String.format("%16s", Long.toString(maxTime, 16)).replace(' ', '0');
        return timeStr + saltStr + this.hf.newHasher().putUnencodedChars((CharSequence)object).putLong(salt).putLong(maxTime).hash().toString();
    }

    private static Long createSalt() {
        Long salt = Math.abs(random.nextLong());
        return salt;
    }

    static {
        random = new Random();
    }
}

