/*
 * Decompiled with CFR 0.152.
 */
package org.butor.config;

import java.io.File;
import java.util.Properties;
import org.butor.config.Config;
import org.butor.utils.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButorConfig
implements Config {
    private Logger _logger = LoggerFactory.getLogger(this.getClass());
    private String _path = null;
    private File _file = null;
    private Properties _props = null;
    private long _lastModified;

    public ButorConfig() {
    }

    public ButorConfig(String path_) {
        this.setPath(path_);
    }

    private void reload() {
        this._logger.info(String.format("Loanding Properties file=%s", this._path));
        if (!this._file.exists()) {
            this._logger.warn(String.format("File does not exists! file=%s", this._path));
            return;
        }
        this._lastModified = this._file.lastModified();
        Properties props = PropertiesHelper.loadProperties(this._file);
        if (props == null) {
            this._logger.warn(String.format("Failed to load properties file! file=%s", this._path));
            return;
        }
        this._logger.info(String.format("Loaded properties file! config=[%s]", props));
        this._props = props;
    }

    @Override
    public String get(String key_) {
        if (this._lastModified < this._file.lastModified()) {
            this._logger.info("Properties file changed. Reloading ...");
            this.reload();
        }
        return this.get(key_, null);
    }

    @Override
    public String get(String key_, String default_) {
        if (this._props == null) {
            return null;
        }
        return this._props.getProperty(key_, default_);
    }

    @Override
    public void set(String key_, String value_) {
        if (this._props == null) {
            return;
        }
        this._props.setProperty(key_, value_);
    }

    @Override
    public void save() {
        if (this._props == null) {
            return;
        }
        PropertiesHelper.saveProperties(this._props, this._file);
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path_) {
        this._path = path_;
        this._file = new File(this._path);
        this.reload();
    }

    public long getLastModified() {
        return this._lastModified;
    }
}

