/*
 * Decompiled with CFR 0.152.
 */
package org.butor.ldap;

import com.google.common.base.Strings;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.butor.ldap.LdapUser;
import org.butor.ldap.LdapUserModel;
import org.butor.ldap.NoCheckSocketFactory;
import org.butor.utils.ApplicationException;
import org.butor.utils.CommonMessageID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapUserModel
implements LdapUserModel {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String ldapUrl = null;
    protected String domain = null;
    protected String searchBase = null;
    protected String adminUsername = null;
    protected String adminPwd = null;

    public DefaultLdapUserModel(String ldapUrl, String domain) {
        this.ldapUrl = ldapUrl;
        this.domain = domain;
    }

    protected DirContext getContext(String principal, String pwd) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapUrl);
        if (this.ldapUrl.toLowerCase().startsWith("ldaps")) {
            env.put("java.naming.security.protocol", "ssl");
            env.put("java.naming.ldap.factory.socket", NoCheckSocketFactory.class.getName());
        }
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", principal);
        env.put("java.naming.security.credentials", pwd);
        return new InitialDirContext(env);
    }

    protected void releaseContext(DirContext ctx) {
        if (ctx != null) {
            try {
                this.logger.debug("Releasing context.");
                ctx.close();
            }
            catch (Exception e) {
                this.logger.error("Error releasing context.", (Throwable)e);
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public LdapUser auth(String username, String pwd) {
        block12: {
            LdapUser ldapUser;
            String id2222222222;
            long t;
            DirContext ctx;
            block11: {
                this.logger.info("Authenticating user {} in ldap {} ...", (Object)username, (Object)this.ldapUrl);
                ctx = null;
                t = System.currentTimeMillis();
                id2222222222 = username;
                String email = username;
                int pos = id2222222222.indexOf("@");
                if (pos == -1) {
                    email = email + "@" + this.domain;
                } else {
                    id2222222222 = id2222222222.substring(0, pos);
                }
                ctx = this.getContext(email, pwd);
                if (ctx != null) break block11;
                LdapUser ldapUser2 = null;
                this.logger.info("Authentication done in ldap {}. Took {} ms", (Object)this.ldapUrl, (Object)(System.currentTimeMillis() - t));
                this.releaseContext(ctx);
                return ldapUser2;
            }
            try {
                String searchFilter = "(&(objectClass=user)(sAMAccountName=" + id2222222222 + "))";
                StringWriter swDomain = new StringWriter();
                String[] domainSplit = this.domain.split("\\.");
                for (int i = 0; i < domainSplit.length; ++i) {
                    swDomain.append(String.format("DC=%s", domainSplit[i]));
                    if (i + 1 >= domainSplit.length) continue;
                    swDomain.append(",");
                }
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(2);
                NamingEnumeration<SearchResult> results = ctx.search(swDomain.toString(), searchFilter, searchControls);
                LdapUser user = null;
                if (results.hasMoreElements()) {
                    SearchResult sr = results.next();
                    Attributes attrs = sr.getAttributes();
                    user = this.retrieveUser(attrs, true);
                }
                ldapUser = user;
            }
            catch (AuthenticationException id2222222222) {
                this.logger.info("Authentication done in ldap {}. Took {} ms", (Object)this.ldapUrl, (Object)(System.currentTimeMillis() - t));
                this.releaseContext(ctx);
                break block12;
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
                {
                    catch (Throwable throwable) {
                        this.logger.info("Authentication done in ldap {}. Took {} ms", (Object)this.ldapUrl, (Object)(System.currentTimeMillis() - t));
                        this.releaseContext(ctx);
                        throw throwable;
                    }
                }
            }
            this.logger.info("Authentication done in ldap {}. Took {} ms", (Object)this.ldapUrl, (Object)(System.currentTimeMillis() - t));
            this.releaseContext(ctx);
            return ldapUser;
        }
        return null;
    }

    private LdapUser retrieveUser(Attributes attrs, boolean noNulls) throws NamingException {
        Attribute sn = attrs.get("sn");
        Attribute givenName = attrs.get("givenName");
        Attribute mail = attrs.get("mail");
        Attribute phone = attrs.get("telephoneNumber");
        Attribute displayName = attrs.get("displayName");
        Attribute name = attrs.get("name");
        Attribute language = attrs.get("language");
        Attribute creationDate = attrs.get("whenCreated");
        Attribute sAMAccountName = attrs.get("sAMAccountName");
        if (noNulls && (sn == null || givenName == null || displayName == null)) {
            return null;
        }
        LdapUser user = new LdapUser();
        user.setUsername(sAMAccountName == null ? null : (String)sAMAccountName.get());
        user.setLastName(sn == null ? null : (String)sn.get());
        user.setFirstName(givenName == null ? null : (String)givenName.get());
        user.setEmail(mail == null ? null : (String)mail.get());
        user.setLanguage(language == null ? null : ((String)language.get()).toLowerCase());
        user.setCreationDate(this.parseLdapDate((String)creationDate.get()));
        if (phone != null) {
            user.setPhone((String)phone.get());
        }
        user.setDisplayName(displayName == null ? null : (String)displayName.get());
        user.setFullName(name == null ? null : (String)name.get());
        return user;
    }

    @Override
    public List<LdapUser> search(String name) {
        List<String> names = null;
        if (!Strings.isNullOrEmpty((String)name)) {
            names = Arrays.asList(name);
        }
        return this.search(names);
    }

    @Override
    public List<LdapUser> search(List<String> names) {
        return this.search(names, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LdapUser> search(List<String> names, int retriesSoFar) {
        if (Strings.isNullOrEmpty((String)this.searchBase)) {
            ApplicationException.exception(CommonMessageID.MISSING_CONFIG.getMessage("searchBase"));
        }
        if (Strings.isNullOrEmpty((String)this.adminUsername)) {
            ApplicationException.exception(CommonMessageID.MISSING_CONFIG.getMessage("adminUsername"));
        }
        if (Strings.isNullOrEmpty((String)this.adminPwd)) {
            ApplicationException.exception(CommonMessageID.MISSING_CONFIG.getMessage("adminPwd"));
        }
        this.logger.info("Searching {} in ldap {} ...", names, (Object)this.ldapUrl);
        long t = System.currentTimeMillis();
        DirContext ctx = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            ctx = this.getContext(this.adminUsername, this.adminPwd);
            if (ctx == null) {
                List<LdapUser> list = null;
                return list;
            }
            LinkedList<LdapUser> list = new LinkedList<LdapUser>();
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"sAMAccountName", "sn", "givenName", "telephoneNumber", "mail", "displayName", "name", "language", "whenCreated"});
            String filter = "(objectclass=user)";
            if (names != null && names.size() > 0) {
                filter = "(&(objectClass=user)(|";
                for (String name : names) {
                    filter = filter + String.format("(displayName=*%s*)(mail=*%s*)(mailNickname=*%s*)(sAMAccountName=*%s*)", name, name, name, name);
                }
                filter = filter + "))";
            }
            results = ctx.search(this.searchBase, filter, controls);
            try {
                while (results.hasMore()) {
                    SearchResult sr = results.next();
                    LdapUser user = this.retrieveUser(sr.getAttributes(), true);
                    if (user == null) continue;
                    list.add(user);
                }
            }
            catch (PartialResultException e) {
                // empty catch block
            }
            LinkedList<LdapUser> linkedList = list;
            return linkedList;
        }
        catch (Exception e) {
            if (retriesSoFar < 2) {
                List<LdapUser> list = this.search(names, retriesSoFar + 1);
                return list;
            }
            this.logger.error("Failed to search in LDAP!", (Throwable)e);
        }
        finally {
            this.logger.info("Search done in ldap {}. Took {} ms", (Object)this.ldapUrl, (Object)(System.currentTimeMillis() - t));
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException namingException) {}
            }
            this.releaseContext(ctx);
        }
        return null;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    public void setAdminPwd(String adminPwd) {
        this.adminPwd = adminPwd;
    }

    protected String parseLdapDate(String ldapDate) {
        String date = null;
        if (ldapDate != null) {
            try {
                this.logger.debug("Parsing date atribute {} ...", (Object)ldapDate);
                if (!Strings.isNullOrEmpty((String)ldapDate) && ldapDate.length() >= 14) {
                    date = ldapDate.substring(0, 4) + "-" + ldapDate.substring(4, 6) + "-" + ldapDate.substring(6, 8) + " " + ldapDate.substring(8, 10) + ":" + ldapDate.substring(10, 12) + ":" + ldapDate.substring(12, 14);
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse ldap date {}!", (Object)ldapDate);
            }
        }
        return date;
    }
}

