/*
 * Decompiled with CFR 0.152.
 */
package org.butor.mail;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.butor.mail.IMailer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Mailer
implements IMailer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Queue<Message> queue = new ConcurrentLinkedQueue<Message>();
    private Session session = null;
    private String smtpHost = null;
    private String smtpPort = "0";
    private String smtpUser = null;
    private String smtpPassword = null;
    private InternetAddress fromRecipient = null;
    private ScheduledExecutorService executor = null;
    private boolean ssl = false;

    public Mailer(ScheduledExecutorService executor) throws IllegalArgumentException, AddressException {
        this.executor = executor;
        this.executor.scheduleWithFixedDelay(this.getMonitor(), 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    protected Runnable getMonitor() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    Message message;
                    while ((message = (Message)Mailer.this.queue.poll()) != null) {
                        String adrs = "";
                        for (Address adr : message.getRecipients(Message.RecipientType.TO)) {
                            adrs = adrs + adr.toString() + ";";
                        }
                        Mailer.this.logger.info("sending mail to {}, subject={}", (Object)adrs, (Object)message.getSubject());
                        Transport.send((Message)message);
                    }
                }
                catch (Exception e) {
                    Mailer.this.logger.error("Failed", (Throwable)e);
                }
            }
        };
    }

    @Override
    public void sendMail(String toRecipients, String subject, String content, String fromRecipient) {
        this.sendMail(toRecipients, subject, content, fromRecipient, "text/plain; charset=UTF-8");
    }

    @Override
    public void sendMail(String toRecipients, String subject, String content, String fromRecipient, String contentType) {
        if (Strings.isNullOrEmpty((String)toRecipients)) {
            this.logger.warn("Cannot send mail!, no recipients specified.");
            return;
        }
        this.sendMail(Arrays.asList(toRecipients.split("[;,]")), subject, content, fromRecipient, contentType);
    }

    @Override
    public void sendMail(List<String> to, String subject, String content, String fromRecipient) {
        this.sendMail(to, subject, content, fromRecipient, "text/plain; charset=UTF-8");
    }

    @Override
    public void sendMail(List<String> to, String subject, String content, String fromRecipient, String contentType) {
        if (to == null || to.size() == 0) {
            this.logger.warn("Cannot send mail!, no recipients specified.");
            return;
        }
        try {
            if (Strings.isNullOrEmpty((String)this.smtpHost)) {
                throw new IllegalArgumentException("smtp host not set!");
            }
            if (Strings.isNullOrEmpty((String)this.smtpPort)) {
                throw new IllegalArgumentException("smtp port not set!");
            }
            if (Strings.isNullOrEmpty((String)fromRecipient) && this.fromRecipient == null) {
                throw new IllegalArgumentException("Missing from recipient arg!");
            }
            if (this.session == null) {
                this.logger.info(String.format("Connecting to smtp host=%s, port=%s, ssl=%s, user=%s, pwd=%s ...", this.smtpHost, this.smtpPort, this.ssl, this.smtpUser, "*"));
                Properties props = new Properties();
                props.setProperty("mail.smtp.host", this.smtpHost);
                props.setProperty("mail.smtp.port", this.smtpPort);
                if (this.ssl) {
                    props.put("mail.smtp.socketFactory.port", this.smtpPort);
                    props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                }
                if (!Strings.isNullOrEmpty((String)this.smtpUser) || !Strings.isNullOrEmpty((String)this.smtpPassword)) {
                    this.logger.info("authenticating ...");
                    props.put("mail.smtp.auth", "true");
                    SMTPAuthenticator auth = new SMTPAuthenticator(this.smtpUser, this.smtpPassword);
                    this.session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
                } else {
                    this.logger.info("Not authenticating cause no user/pwd provided!");
                    this.session = Session.getDefaultInstance((Properties)props);
                }
            }
            InternetAddress ia = this.fromRecipient;
            if (!Strings.isNullOrEmpty((String)fromRecipient)) {
                ia = new InternetAddress(fromRecipient);
            }
            MimeMessage message = new MimeMessage(this.session);
            message.setFrom((Address)ia);
            InternetAddress[] dests = new InternetAddress[to.size()];
            int i = 0;
            for (String tt : to) {
                dests[i++] = new InternetAddress(tt);
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])dests);
            message.setSubject(subject);
            message.setContent((Object)content, contentType);
            this.logger.info("queued mail to {}, subject={}", (Object)to.toString(), (Object)subject);
            this.queue.add((Message)message);
        }
        catch (Exception e) {
            this.logger.error("Failed", (Throwable)e);
        }
    }

    public String getFromRecipient() {
        if (this.fromRecipient != null) {
            return this.fromRecipient.getAddress();
        }
        return null;
    }

    public void setFromRecipient(String fromRecipient) throws AddressException {
        this.fromRecipient = new InternetAddress(fromRecipient);
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public void setSmtpPort(String smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setSmtpUser(String smtpUser) {
        this.smtpUser = smtpUser;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        props.put("mail.smtp.host", "smtp.gmail.com");
        props.put("mail.smtp.socketFactory.port", "465");
        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.port", "465");
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("id@gmail.com", "pwd");
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress("id@gmail.com"));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)"id@gmail.com"));
            message.setSubject("Testing java.mail ssl");
            message.setText("Test Mail");
            Transport.send((Message)message);
            System.out.println("Done");
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    private class SMTPAuthenticator
    extends Authenticator {
        String user;
        String pwd;

        private SMTPAuthenticator(String user, String pwd) {
            this.user = user;
            this.pwd = pwd;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.pwd);
        }
    }
}

