/*
 * Decompiled with CFR 0.152.
 */
package org.butor.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class CSVWriter {
    private final List<Field> fields = Lists.newArrayList();
    private final Map<String, Integer> fieldsIndex = Maps.newHashMap();
    private final Map<String, String> fieldsDesc = Maps.newHashMap();
    private final String delim;
    private final String quoteChar;

    CSVWriter(List<Field> fields, String delim, String quoteChar) {
        this.fields.addAll(fields);
        int index = 0;
        this.delim = delim;
        this.quoteChar = quoteChar;
        for (Field f : fields) {
            this.fieldsIndex.put(f.header, index++);
            if (f.desc == null) continue;
            this.fieldsDesc.put(f.header, f.desc);
        }
    }

    public String getHeader() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fields.size(); ++i) {
            Field f = this.fields.get(i);
            String header = f.header;
            if (this.fieldsDesc.containsKey(header)) {
                header = this.fieldsDesc.get(header);
            }
            if (f.quoted) {
                sb.append(this.quoteChar);
                sb.append(header);
                sb.append(this.quoteChar);
            } else {
                sb.append(header);
            }
            if (i + 1 == this.fields.size()) continue;
            sb.append(this.delim);
        }
        return sb.toString();
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public String getLine(String ... textArray) {
        Preconditions.checkArgument((textArray.length == this.getFieldCount() ? 1 : 0) != 0, (Object)"Check array size");
        String quotedChar = "\\\\" + this.quoteChar;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < textArray.length; ++i) {
            String text = textArray[i];
            if (text != null) {
                Field f = this.fields.get(i);
                if (f.quoted) {
                    text = text.replaceAll(this.quoteChar, quotedChar);
                    sb.append(this.quoteChar);
                    sb.append(text);
                    sb.append(this.quoteChar);
                } else {
                    sb.append(text);
                }
            }
            if (i + 1 == this.fields.size()) continue;
            sb.append(this.delim);
        }
        return sb.toString();
    }

    public String getLine(Map<String, String> row) {
        Preconditions.checkArgument((row != null ? 1 : 0) != 0, (Object)"Check bean != null");
        String quotedChar = "\\\\" + this.quoteChar;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Field f : this.fields) {
            String obj = row.get(f.header);
            if (obj == null) {
                obj = "";
            }
            String text = obj.toString();
            if (f.quoted) {
                text = text.replaceAll(this.quoteChar, quotedChar);
                sb.append(this.quoteChar);
                sb.append(text);
                sb.append(this.quoteChar);
            } else {
                sb.append(text);
            }
            if (++i >= this.fields.size()) continue;
            sb.append(this.delim);
        }
        return sb.toString();
    }

    static class Field {
        final String header;
        final boolean quoted;
        final String desc;

        Field(String header, boolean quoted) {
            this(header, null, quoted);
        }

        Field(String header, String desc, boolean quoted) {
            this.header = header;
            this.quoted = quoted;
            this.desc = desc;
        }
    }
}

