/*
 * Decompiled with CFR 0.152.
 */
package org.butor.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import org.butor.utils.CSVWriter;

public class CSVWriterBuilder {
    private final List<CSVWriter.Field> fields = Lists.newArrayList();
    private String delim = ";";
    private String quoteChar = "\"";

    public CSVWriterBuilder addHeader(String header) {
        this.addHeader(header, null, false);
        return this;
    }

    public CSVWriterBuilder addHeader(String header, String desc, boolean quotedColumn) {
        this.fields.add(new CSVWriter.Field(header, desc, quotedColumn));
        return this;
    }

    public CSVWriterBuilder setQuoteCharacter(String quoteChar) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)quoteChar) ? 1 : 0) != 0, (Object)"QuoteChar is mandatory");
        this.quoteChar = quoteChar;
        return this;
    }

    public CSVWriterBuilder setDelimiter(String delim) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)delim) ? 1 : 0) != 0, (Object)"QuoteChar is mandatory");
        this.delim = delim;
        return this;
    }

    public CSVWriter build() {
        return new CSVWriter(this.fields, this.delim, this.quoteChar);
    }
}

