/*
 * Decompiled with CFR 0.152.
 */
package org.butor.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public enum CommonDateFormat {
    HHMM("HH:mm"),
    HHMMSS("HH:mm:ss"),
    YYYYMMDD("yyyy-MM-dd"),
    YYYYMMDD_COMPACT("yyyyMMdd"),
    YYYYMMDD_HHMM("yyyy-MM-dd HH:mm"),
    YYYYMMDD_HHMM_COMPACT("yyyyMMddHHmm"),
    YYYYMMDD_HHMMSS("yyyy-MM-dd HH:mm:ss"),
    YYYYMMDD_HHMMSS_COMPACT("yyyyMMddHHmmss"),
    YYYYMMDD_HHMMSS_WITHMS("yyyy-MM-dd HH:mm:ss.SSS"),
    YYYYMMDD_HHMMSS_WITHMS_COMPACT("yyyyMMddHHmmssSSS"),
    ISO8601("yyyy-MM-dd'T'HH:mm:ss'Z'", TimeZone.getTimeZone("UTC")),
    ISO8601_WITHMS("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", TimeZone.getTimeZone("UTC"));

    private final String pattern;
    private final TimeZone tz;
    private ThreadLocal<SimpleDateFormat> tl = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat(CommonDateFormat.this.pattern);
            sdf.setLenient(false);
            sdf.setTimeZone(CommonDateFormat.this.tz);
            return sdf;
        }
    };

    private CommonDateFormat(String pattern) {
        this(pattern, TimeZone.getDefault());
    }

    private CommonDateFormat(String pattern, TimeZone tz) {
        this.pattern = pattern;
        this.tz = tz;
    }

    public Date parse(String date) throws ParseException {
        return this.tl.get().parse(date);
    }

    public String format(Date date) {
        return this.tl.get().format(date);
    }
}

