/*
 * Decompiled with CFR 0.152.
 */
package org.butor.utils;

import org.butor.utils.Message;
import org.butor.utils.MessageID;

public enum CommonMessageID implements MessageID
{
    SERVICE_NOT_AVAILABLE(Message.MessageType.ERROR),
    SUCCESS(Message.MessageType.INFO),
    SUCCESSFULL_UPDATE(Message.MessageType.INFO),
    SERVICE_TIMEOUT(Message.MessageType.ERROR),
    SERVICE_FAILURE(Message.MessageType.ERROR),
    MISSING_ARG(Message.MessageType.ERROR),
    MISSING_CONFIG(Message.MessageType.ERROR),
    INVALID_ARG(Message.MessageType.ERROR),
    NOT_FOUND(Message.MessageType.INFO);

    private String sysId = "common";
    private final Message.MessageType type;
    private final Message messageObject;

    private CommonMessageID(Message.MessageType type) {
        this.type = type;
        this.messageObject = new Message(this);
    }

    public Message getMessage() {
        return this.messageObject;
    }

    public Message getMessage(String message) {
        return new Message(this, message);
    }

    @Override
    public String getId() {
        return this.name();
    }

    @Override
    public String getSysId() {
        return this.sysId;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    @Override
    public Message.MessageType getMessageType() {
        return this.type;
    }
}

