/*
 * Decompiled with CFR 0.152.
 */
package org.butor.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriteriaSanitizer<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected boolean cleanField(T criteria, String fieldName, Class<?> fieldType, Object fieldValue, Method writeMethod) {
        return false;
    }

    protected void defaultCleanField(T criteria, String fieldName, Class<?> fieldType, Object fieldValue, Method writeMethod) {
        if (String.class.equals(fieldType)) {
            String newValue = Strings.emptyToNull((String)((String)fieldValue));
            try {
                writeMethod.invoke(criteria, newValue);
            }
            catch (Exception e) {
                this.logger.warn("Unable to write value from class {}, field {}, cause : {}", new Object[]{fieldType, fieldName, e});
            }
        }
    }

    public void clean(T criteria) {
        Preconditions.checkNotNull(criteria, (Object)"Criteria object is mandatory");
        try {
            PropertyDescriptor[] pds;
            BeanInfo bi = Introspector.getBeanInfo(criteria.getClass());
            for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
                String name = pd.getName();
                if ("class".equals(name)) continue;
                Class<?> type = pd.getPropertyType();
                Object value = null;
                try {
                    value = pd.getReadMethod().invoke(criteria, new Object[0]);
                }
                catch (Exception e) {
                    this.logger.warn("Unable to read value from class {}, field {}, cause : {}", new Object[]{type, name, e});
                }
                if (this.cleanField(criteria, name, type, value, pd.getWriteMethod())) continue;
                this.defaultCleanField(criteria, name, type, value, pd.getWriteMethod());
            }
        }
        catch (IntrospectionException e) {
            this.logger.error("Unable to introspect bean! class : {}, object : {}, exception : {}", new Object[]{criteria.getClass(), criteria, e});
        }
    }
}

