/*
 * Decompiled with CFR 0.152.
 */
package org.butor.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateUtils {
    public static final int MS_PER_DAY = 86400000;
    public static final int MS_PER_HOUR = 3600000;
    public static final int MS_PER_MINUTE = 60000;
    public static final int MS_PER_SECOND = 1000;
    public static final String DATE_FORMAT_NORMAL = "yyyy/MM/dd HH:mm:ss";
    public static final String DATE_FORMAT_NORMAL_DASH = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_FULL = "yyyy/MM/dd HH:mm:ss SSS";
    public static final String DATE_FORMAT_FULL_DASH = "yyyy-MM-dd HH:mm:ss SSS";
    public static final String DATE_FORMAT_COMPACT = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT_HHMMSS = "HH:mm:ss";
    public static final String DATE_FORMAT_HHMM = "HH:mm";
    public static final String DATE_FORMAT_YYYYMMDD = "yyyy/MM/dd";
    public static final String DATE_FORMAT_YYYYMMDD_DASH = "yyyy-MM-dd";
    public static final String DATE_FORMAT_YYYYMMDD_COMPACT = "yyyyMMdd";
    protected static final String[] DATE_FORMATS = new String[]{"yyyy/MM/dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd", "yyyy-MM-dd", "yyyyMMddHHmmss", "yyyyMMdd", "HH:mm:ss"};
    public static final Date NULL_MIN_DATE = new Date(-5364644400000L);
    public static final long NULL_MIN_DATE_DAYS = -62090L;
    public static final Date NULL_MAX_DATE = new Date(32503611600000L);
    public static final long NULL_MAX_DATE_DAYS = 376199L;

    public static String formatHHMMSS(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Got null date");
        }
        SimpleDateFormat hhmmssFormat = new SimpleDateFormat(DATE_FORMAT_HHMMSS, Locale.getDefault());
        return hhmmssFormat.format(DateUtils.getRealDate(date));
    }

    public static String formatHHMM(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Got null date");
        }
        SimpleDateFormat hhmmFormat = new SimpleDateFormat(DATE_FORMAT_HHMM, Locale.getDefault());
        return hhmmFormat.format(DateUtils.getRealDate(date));
    }

    public static String formatYYYYMMDD(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Got null date");
        }
        SimpleDateFormat yyyymmddFormat = new SimpleDateFormat(DATE_FORMAT_YYYYMMDD, Locale.getDefault());
        return yyyymmddFormat.format(DateUtils.getRealDate(date));
    }

    private static Date getRealDate(Date date) {
        Date d = null;
        if (date instanceof Timestamp) {
            Timestamp timeStamp = (Timestamp)date;
            long tsValue = timeStamp.getTime();
            d = new Date(tsValue += (long)(timeStamp.getNanos() / 1000000));
        } else if (date instanceof Date) {
            d = date;
        }
        return d;
    }

    public static String formatDate(String pattern, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Got null date");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Got null pattern");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        return dateFormat.format(DateUtils.getRealDate(date));
    }

    public static Date parseDate(String stringDate) throws ParseException {
        if (stringDate == null) {
            throw new ParseException("cant parse null date!", 0);
        }
        Date d = null;
        for (int i = 0; i < DATE_FORMATS.length; ++i) {
            try {
                d = DateUtils.privateParseDate(DATE_FORMATS[i], stringDate);
                break;
            }
            catch (ParseException e) {
                d = null;
                continue;
            }
        }
        if (d == null) {
            throw new ParseException("Parsing " + stringDate + " failed because the format is not supported !!!", 0);
        }
        return d;
    }

    public static Date parseDate(String pattern, String stringDate) throws ParseException {
        if (stringDate == null) {
            throw new ParseException("can't parse null date!", 0);
        }
        if (pattern == null) {
            throw new ParseException("can't parse using null pattern!", 0);
        }
        return DateUtils.privateParseDate(pattern, stringDate);
    }

    public static void addToDate(Date date, int part, int value) {
        if (date == null) {
            throw new IllegalArgumentException("Got null date");
        }
        long time = date.getTime();
        switch (part) {
            case 5: {
                time += (long)(86400000 * value);
                break;
            }
            case 11: {
                time += (long)(3600000 * value);
                break;
            }
            case 12: {
                time += (long)(60000 * value);
                break;
            }
            case 13: {
                time += (long)(1000 * value);
            }
        }
        date.setTime(time);
    }

    public static int getDatePart(Date date, int part) {
        if (date == null) {
            throw new IllegalArgumentException("Got null date");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(part);
    }

    public static void setDatePart(Date date, int part, int value) {
        if (date == null) {
            throw new IllegalArgumentException("Got null date");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(part, value);
        date.setTime(calendar.getTime().getTime());
    }

    public static void setDateHHMMSS_GMT(Date date, Date time) {
        if (date == null) {
            throw new IllegalArgumentException("Got null date");
        }
        if (time == null) {
            throw new IllegalArgumentException("Got null time");
        }
        long d = date.getTime() / 86400000L;
        long t = time.getTime() % 86400000L;
        date.setTime(d * 86400000L + t);
    }

    public static void resetDateHHMMSS_GMT(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Got null date");
        }
        long d = date.getTime() / 86400000L;
        date.setTime(d * 86400000L);
    }

    public static void resetDateYYYYMMDD_GMT(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Got null date");
        }
        long t = date.getTime() % 86400000L;
        date.setTime(t);
    }

    public static void main(String[] args) throws ParseException {
        Date d = DateUtils.parseDate("2002/08/13");
        System.out.println(d);
        d = DateUtils.parseDate("2002-08-13");
        System.out.println(d);
        d = DateUtils.parseDate("2002/08/13 10:25:39");
        System.out.println(d);
        d = DateUtils.parseDate("2002-08-13 10:25:39");
        System.out.println(d);
    }

    public static boolean isNullDate(Date date) {
        return DateUtils.isNullDateMin(date) || DateUtils.isNullDateMax(date);
    }

    public static boolean isNullDateMin(Date date) {
        return date == null || date.getTime() / 86400000L == -62090L;
    }

    public static boolean isNullDateMax(Date date) {
        return date == null || date.getTime() / 86400000L == 376199L;
    }

    private static Date privateParseDate(String pattern, String stringDate) throws ParseException {
        Date date = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setLenient(false);
        date = dateFormat.parse(stringDate);
        return date;
    }

    public Date clearTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public Date eodTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }
}

