/*
 * Decompiled with CFR 0.152.
 */
package org.butor.utils;

import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DiffUtils {
    public static Set<String> getDifferences(Object o1, Object o2) {
        TreeSet<String> diffSet = new TreeSet<String>();
        Map<String, Object> mapObject1 = DiffUtils.getFieldMap(o1);
        Map<String, Object> mapObject2 = DiffUtils.getFieldMap(o2);
        DiffUtils.populateDiffSet(diffSet, mapObject1, mapObject2);
        DiffUtils.populateDiffSet(diffSet, mapObject2, mapObject1);
        return diffSet;
    }

    private static void populateDiffSet(Set<String> diffSet, Map<String, Object> map1, Map<String, Object> map2) {
        for (Map.Entry<String, Object> entry : map1.entrySet()) {
            String fieldName = entry.getKey();
            Object v1 = entry.getValue();
            Object v2 = map2.get(fieldName);
            if ((v1 == null || v1.equals(v2)) && (v2 == null || v2.equals(v1))) continue;
            diffSet.add(fieldName);
        }
    }

    private static Map<String, Object> getFieldMap(Object o1) {
        TreeMap<String, Object> mapObject1 = new TreeMap<String, Object>();
        for (Field f : o1.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            try {
                mapObject1.put(f.getName(), f.get(o1));
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return mapObject1;
    }
}

