/*
 * Decompiled with CFR 0.152.
 */
package org.butor.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestHelper {
    private static Logger _logger = LoggerFactory.getLogger((String)DigestHelper.class.getName());
    public static final String SYSTEM_PROPERTY_REALM_ENCRYPTION_ALGORITHM = "butor_realm_encryption_algorithm";
    public static final String ALGORITHM_SHA1 = "SHA1";
    public static final String PROPERTY_ENCRYPTION_ALGORITHM = "encryption_algorithm";
    private static final int SUN_MISC_BASE64ENCODER_MAX_LINE_LENGTH = 76;

    public static String encrypt(String str, String algo) {
        if (str == null) {
            _logger.warn("Got null string to encrypt!");
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algo);
        }
        catch (NoSuchAlgorithmException e) {
            _logger.error("Failed", (Throwable)e);
            return null;
        }
        try {
            md.update(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            _logger.error("Failed", (Throwable)e);
            return null;
        }
        byte[] raw = md.digest();
        String hash = DigestHelper.encodeLikeSunMiscBASE64Encoder(raw);
        return hash;
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        StringBuffer hex = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            hex.append(Character.forDigit((bytes[i] & 0xF0) >> 4, 16));
            hex.append(Character.forDigit(bytes[i] & 0xF, 16));
        }
        return hex.toString();
    }

    private static String encodeLikeSunMiscBASE64Encoder(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        String encoded = DatatypeConverter.printBase64Binary((byte[])bytes);
        for (int i = 0; i < encoded.length(); i += 76) {
            if (i != 0) {
                result.append('\n');
            }
            result.append(encoded.substring(i, Math.min(encoded.length(), i + 76)));
        }
        if (encoded.length() % 76 == 0 && !encoded.endsWith("=")) {
            result.append('\n');
        }
        return result.toString();
    }
}

