/*
 * Decompiled with CFR 0.152.
 */
package org.butor.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileHelper {
    private static Logger _logger = LoggerFactory.getLogger((String)FileHelper.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        FileInputStream is = null;
        OutputStream os = null;
        try {
            is = new FileInputStream(src);
            os = new FileOutputStream(dst);
            while (((InputStream)is).available() > 0) {
                os.write(((InputStream)is).read());
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static boolean deleteFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int ii = 0; ii < files.length; ++ii) {
                if (FileHelper.deleteFile(files[ii])) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static String getPasswordFromFile(String passwordFile) {
        _logger.info("Getting pwd from file [" + passwordFile + "] ...");
        String strPassword = null;
        if (null == passwordFile) {
            _logger.warn("Got NULL password filename!");
            return null;
        }
        try {
            FileReader objPasswordFile = new FileReader(passwordFile);
            BufferedReader objPasswordReader = new BufferedReader(objPasswordFile);
            strPassword = objPasswordReader.readLine();
            if (null != strPassword) {
                strPassword = strPassword.trim();
            } else {
                _logger.warn("No password in file [" + passwordFile + "]");
            }
            objPasswordFile.close();
        }
        catch (FileNotFoundException e) {
            _logger.error("Failed", (Throwable)e);
        }
        catch (IOException e) {
            _logger.error("Failed", (Throwable)e);
        }
        return strPassword;
    }
}

