/*
 * Decompiled with CFR 0.152.
 */
package org.butor.utils;

import org.butor.utils.MessageID;

public class Message {
    private final String id;
    private String sysId;
    private final MessageType type;
    private final String message;

    public String getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public Message(MessageID messageID) {
        this(messageID, null);
    }

    public Message(MessageID messageID, String message_) {
        this.id = messageID.getId();
        this.sysId = messageID.getSysId();
        this.type = messageID.getMessageType();
        this.message = message_;
    }

    public Message(int id_, MessageType type_, String message_) {
        this(String.valueOf(id_), type_, message_, null);
    }

    public Message(String id_, MessageType type_, String message_) {
        this(id_, type_, message_, null);
    }

    public Message(String id, MessageType type, String message, String sysId) {
        this.id = id;
        this.type = type;
        this.message = message;
        this.sysId = sysId;
    }

    public Message(String message_) {
        this(0, MessageType.INFO, message_);
    }

    public String toString() {
        return String.format("{id:%s, type:%s, message:%s, sysid:%s}", new Object[]{this.id, this.type, this.message, this.sysId});
    }

    public MessageType getType() {
        return this.type;
    }

    public Message setSysId(String sysId) {
        this.sysId = sysId;
        return this;
    }

    public String getSysId() {
        return this.sysId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.sysId == null ? 0 : this.sysId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.sysId == null ? other.sysId != null : !this.sysId.equals(other.sysId)) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum MessageType {
        DATA,
        INFO,
        WARNING,
        ERROR;

    }
}

