/*
 * Decompiled with CFR 0.152.
 */
package org.butor.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesHelper {
    private static Logger _logger = LoggerFactory.getLogger((String)PropertiesHelper.class.getName());

    private PropertiesHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) {
        if (file == null) {
            _logger.warn("Got null  file name!");
            return null;
        }
        if (!file.exists()) {
            _logger.warn("File does not exists! file=[" + file.getPath() + "]");
            return null;
        }
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            props.load(fis);
        }
        catch (Exception e) {
            _logger.error("Failed", (Throwable)e);
            Properties properties = null;
            return properties;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveProperties(Properties props, File file) {
        if (props == null) {
            _logger.error("Got null Properties!");
            return false;
        }
        if (file == null) {
            _logger.error("Got null file name!");
            return false;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            props.store(fos, "");
        }
        catch (Exception e) {
            _logger.error("Failed", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }
}

