/*
 * Decompiled with CFR 0.152.
 */
package org.butor.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionInfo {
    private static final String BUILD_TIME = "Build-Time";
    private static final String IMPLEMENTATION_BUILD = "Implementation-Build";
    private static final String DEVELOPMENT_VERSION = "DevelopmentVersion";
    private static final String DEVELOPMENT_BUILD = "DevelopmentBuild";
    private static final String UNKNOWN_TIMESTAMP = "Unknown";
    private static final Logger logger = LoggerFactory.getLogger(VersionInfo.class);
    public final String GROUP_ID;
    public final String ARTIFACT_ID;
    public final String VERSION;
    public final String BUILD;
    public final String TIMESTAMP;

    private VersionInfo(String groupId, String artifactId) {
        String version = DEVELOPMENT_VERSION;
        String build = DEVELOPMENT_BUILD;
        String timestamp = UNKNOWN_TIMESTAMP;
        this.GROUP_ID = groupId;
        this.ARTIFACT_ID = artifactId;
        try {
            Manifest manifest = VersionInfo.getManifest(groupId, artifactId);
            version = this.extractVersionFromManifest(manifest);
            build = this.extractBuildNumberFromManifest(manifest);
            timestamp = this.extractTimestampFromManifest(manifest);
        }
        catch (Throwable e) {
            logger.error("Unexpected Error : {}", e);
        }
        this.VERSION = version;
        this.BUILD = build;
        this.TIMESTAMP = timestamp;
    }

    private static Manifest getManifest(String groupId, String artifactId) throws Exception {
        URL manifestRessource;
        String pomPropPath;
        URL pomRessource;
        if (groupId != null && artifactId != null && (pomRessource = ClassLoader.getSystemResource(pomPropPath = String.format("META-INF/maven/%s/%s/pom.properties", groupId, artifactId))) != null && (manifestRessource = new URL(pomRessource.toString().replace(pomPropPath, "META-INF/MANIFEST.MF"))) != null) {
            try {
                logger.debug("Opening MANIFEST.MF : {}", (Object)manifestRessource);
                Manifest manifest = new Manifest(manifestRessource.openStream());
                return manifest;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String extractVersionFromManifest(Manifest manifest) {
        String versionNumber = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        if (versionNumber == null) {
            versionNumber = DEVELOPMENT_VERSION;
        }
        return versionNumber;
    }

    private String extractBuildNumberFromManifest(Manifest manifest) {
        String buildNumber = manifest.getMainAttributes().getValue(IMPLEMENTATION_BUILD);
        if (buildNumber == null) {
            buildNumber = DEVELOPMENT_BUILD;
        }
        return buildNumber;
    }

    private String extractTimestampFromManifest(Manifest manifest) {
        String timestamp = manifest.getMainAttributes().getValue(BUILD_TIME);
        if (timestamp == null) {
            timestamp = UNKNOWN_TIMESTAMP;
        }
        return timestamp;
    }

    public String toString() {
        return String.format("VersionInfo [GROUP_ID=%s, ARTIFACT_ID=%s, VERSION=%s, BUILD=%s, TIMESTAMP=%s]", this.GROUP_ID, this.ARTIFACT_ID, this.VERSION, this.BUILD, this.TIMESTAMP);
    }

    public static class VersionInfoMapBuilder {
        private static final Pattern groupIdArtifact = Pattern.compile("META-INF/maven/(.*)/(.*)/pom.properties");
        private static final Predicate<String> ALWAYS_TRUE = Predicates.alwaysTrue();
        public static final Predicate<String> BUTOR_GROUP_ID_PREDICATE = new Predicate<String>(){

            public boolean apply(String input) {
                return input != null && input.startsWith("com.butor/");
            }
        };

        public Map<String, VersionInfo> build() {
            return this.build(ALWAYS_TRUE);
        }

        public Map<String, VersionInfo> build(Predicate<String> keyFilterPredicate) {
            ClassPath cp;
            try {
                cp = ClassPath.from((ClassLoader)VersionInfo.class.getClassLoader());
            }
            catch (IOException e) {
                logger.warn("Unable to fetch versioning information from classpath ! {}", (Throwable)e);
                return Collections.emptyMap();
            }
            Iterable pomPropFiles = Iterables.filter((Iterable)cp.getResources().asList(), (Predicate)new Predicate<ClassPath.ResourceInfo>(){

                public boolean apply(ClassPath.ResourceInfo input) {
                    if (input.getResourceName().contains("pom.properties")) {
                        Matcher m = groupIdArtifact.matcher(input.getResourceName());
                        return m.matches();
                    }
                    return false;
                }
            });
            Iterable versionsResources = Iterables.transform((Iterable)pomPropFiles, (Function)new Function<ClassPath.ResourceInfo, VersionInfo>(){

                public VersionInfo apply(ClassPath.ResourceInfo input) {
                    Matcher m = groupIdArtifact.matcher(input.getResourceName());
                    if (m.matches()) {
                        String groupId = m.group(1);
                        String artifactId = m.group(2);
                        return new VersionInfo(groupId, artifactId);
                    }
                    return null;
                }
            });
            ImmutableMap versionMap = Maps.uniqueIndex((Iterable)versionsResources, (Function)new Function<VersionInfo, String>(){

                public String apply(VersionInfo input) {
                    return String.format("%s/%s", input.GROUP_ID, input.ARTIFACT_ID);
                }
            });
            return Maps.filterKeys((Map)versionMap, keyFilterPredicate);
        }
    }

    public static class VersionInfoBuilder {
        String groupId;
        String artifactId;

        public VersionInfoBuilder setGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public VersionInfoBuilder setArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public VersionInfo build() {
            return new VersionInfo(this.groupId, this.artifactId);
        }
    }
}

