/*
 * Decompiled with CFR 0.152.
 */
package org.butor.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipEntryInputStream
extends InputStream {
    InputStream is = null;
    ZipFile zf = null;
    int available = -1;

    public ZipEntryInputStream(File file, String entryName) throws IOException {
        this.zf = new ZipFile(file);
        ZipEntry ze = this.zf.getEntry(entryName);
        if (ze == null) {
            return;
        }
        this.is = this.zf.getInputStream(ze);
        this.available = (int)ze.getSize();
    }

    @Override
    public int read() throws IOException {
        if (this.is == null) {
            return -1;
        }
        int b = this.is.read();
        this.available = b != -1 ? --this.available : 0;
        return b;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        if (this.is == null) {
            return -1;
        }
        int chunkLen = this.is.read(bytes);
        this.available -= chunkLen;
        return chunkLen;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (this.is == null) {
            return -1;
        }
        int chunkLen = this.is.read(bytes, off, len);
        this.available -= chunkLen;
        return chunkLen;
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    @Override
    public int available() throws IOException {
        return this.available;
    }
}

