/*
 * Decompiled with CFR 0.152.
 */
package org.butor.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.butor.utils.IWriteListener;
import org.butor.zip.ZipEntryInfo;
import org.butor.zip.ZipEntryInputStream;

public class ZipUtils {
    public static void main(String[] args) throws Exception {
        File zipFile = new File(args[0]);
        String entryName = args[1];
        List list = ZipUtils.listContent(zipFile);
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                System.out.println((ZipEntryInfo)it.next());
            }
        }
        File file = new File(entryName);
        String name = file.getName();
        System.out.println("Get bytes of " + name + ":");
        byte[] bytes = ZipUtils.getResourceBytes(zipFile, name);
        System.out.println(new String(bytes));
        System.out.println("Get InputStream of " + name + ":");
        try {
            bytes = new byte[128];
            InputStream zeis = ZipUtils.getResourceInputStream(zipFile, name);
            while (zeis.available() > 0) {
                int chunk = zeis.read(bytes);
                System.out.print(new String(bytes, 0, chunk));
            }
            zeis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List listContent(File file) throws ZipException {
        ZipFile zf = null;
        try {
            LinkedList<ZipEntryInfo> list = new LinkedList<ZipEntryInfo>();
            zf = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                ZipEntryInfo zei = new ZipEntryInfo();
                zei.setName(ze.getName());
                zei.setDirectory(ze.isDirectory());
                zei.setMethod(ze.getMethod());
                zei.setSize(ze.getSize());
                zei.setCompressedSize(ze.getCompressedSize());
                list.add(zei);
            }
            zf.close();
            zf = null;
            LinkedList<ZipEntryInfo> linkedList = list;
            return linkedList;
        }
        catch (Exception e) {
            throw new ZipException(e.getMessage());
        }
        finally {
            try {
                if (zf != null) {
                    zf.close();
                }
            }
            catch (Exception e2) {
                throw new ZipException(e2.getMessage());
            }
        }
    }

    public static byte[] getResourceBytes(File file, String resName) throws ZipException {
        ZipFile zf = null;
        InputStream is = null;
        try {
            int chunk;
            zf = new ZipFile(file);
            ZipEntry ze = zf.getEntry(resName);
            if (ze == null) {
                byte[] byArray = null;
                return byArray;
            }
            is = zf.getInputStream(ze);
            int size = (int)ze.getSize();
            if (size == -1) {
                byte[] e2 = null;
                return e2;
            }
            byte[] bytes = new byte[size];
            int rb = 0;
            while ((chunk = is.read(bytes, rb, size - rb)) > 0) {
                rb += chunk;
            }
            is.close();
            is = null;
            zf.close();
            zf = null;
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            throw new ZipException(e.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            try {
                if (zf != null) {
                    zf.close();
                }
            }
            catch (IOException e2) {
                throw new ZipException(e2.getMessage());
            }
        }
    }

    public static CharBuffer getResourceChars(File file, String resName, String charsetName) throws ZipException {
        ZipFile zf = null;
        InputStreamReader isr = null;
        try {
            int chunk;
            zf = new ZipFile(file);
            ZipEntry ze = zf.getEntry(resName);
            if (ze == null) {
                CharBuffer charBuffer = null;
                return charBuffer;
            }
            isr = charsetName != null ? new InputStreamReader(zf.getInputStream(ze), charsetName) : new InputStreamReader(zf.getInputStream(ze));
            int size = (int)ze.getSize();
            if (size <= 0) {
                CharBuffer e2 = null;
                return e2;
            }
            CharBuffer cb = CharBuffer.allocate(size);
            char[] buffer = new char[1024];
            int rb = 0;
            while ((chunk = isr.read(buffer)) > 0) {
                rb += chunk;
                cb.put(buffer, 0, chunk);
            }
            isr.close();
            isr = null;
            zf.close();
            zf = null;
            CharBuffer charBuffer = cb;
            return charBuffer;
        }
        catch (Exception e) {
            throw new ZipException(e.getMessage());
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException e2) {
                throw new ZipException(e2.getMessage());
            }
            try {
                if (zf != null) {
                    zf.close();
                }
            }
            catch (IOException e2) {
                throw new ZipException(e2.getMessage());
            }
        }
    }

    public static InputStream getResourceInputStream(File file, String entryName) throws IOException {
        return new ZipEntryInputStream(file, entryName);
    }

    public static int putResource(File file, String entryName, InputStream fis, long lastModified) throws ZipException {
        return ZipUtils.putResource(file, entryName, fis, lastModified, null);
    }

    public static int putResource(File file, String entryName, InputStream fis, long lastModified, IWriteListener writeListener) throws ZipException {
        if (fis == null) {
            return -1;
        }
        boolean completed = false;
        ZipFile zf = null;
        File tmpFile = null;
        ZipOutputStream zos = null;
        try {
            ZipEntry ze;
            if (file.exists()) {
                tmpFile = new File(file.getPath() + ".part");
                zos = new ZipOutputStream(new FileOutputStream(tmpFile));
                zf = new ZipFile(file);
                Enumeration<? extends ZipEntry> e = zf.entries();
                while (e.hasMoreElements()) {
                    ze = e.nextElement();
                    if (ze.getName().equals(entryName)) continue;
                    zos.putNextEntry(ze);
                    InputStream is = zf.getInputStream(ze);
                    int size = (int)ze.getSize();
                    if (size > 0) {
                        int chunk;
                        byte[] bytes = new byte[128];
                        int rb = 0;
                        while ((chunk = is.read(bytes)) > 0) {
                            rb += chunk;
                            zos.write(bytes, 0, chunk);
                        }
                    }
                    is.close();
                    zos.closeEntry();
                }
                zf.close();
                zf = null;
            } else {
                zos = new ZipOutputStream(new FileOutputStream(file));
            }
            byte[] bytes = new byte[1024];
            ze = new ZipEntry(entryName);
            ze.setMethod(8);
            ze.setTime(lastModified);
            zos.putNextEntry(ze);
            if (writeListener != null) {
                writeListener.writeStarted(fis.available());
            }
            int resourceSize = 0;
            int chunk = 0;
            while ((chunk = fis.read(bytes)) > 0) {
                resourceSize += chunk;
                zos.write(bytes, 0, chunk);
                if (writeListener == null) continue;
                writeListener.writeChunkSize(chunk);
            }
            completed = true;
            zos.closeEntry();
            zos.finish();
            zos.close();
            zos = null;
            if (tmpFile != null) {
                file.delete();
                tmpFile.renameTo(file);
            }
            int n = resourceSize;
            return n;
        }
        catch (Exception e) {
            if (!completed && writeListener != null) {
                writeListener.writeAborted();
            }
            throw new ZipException(e.getMessage());
        }
        finally {
            if (completed && writeListener != null) {
                writeListener.writeCompleted();
            }
            try {
                if (zf != null) {
                    zf.close();
                }
            }
            catch (IOException e2) {
                throw new ZipException(e2.getMessage());
            }
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException e2) {
                throw new ZipException(e2.getMessage());
            }
        }
    }

    public static boolean removeResource(File file, String entryName) throws ZipException {
        if (!file.exists()) {
            return false;
        }
        ZipFile zf = null;
        boolean foundEntry = false;
        try {
            zf = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (!ze.getName().equals(entryName)) continue;
                foundEntry = true;
                break;
            }
            zf.close();
            zf = null;
        }
        catch (Exception e) {
            throw new ZipException(e.getMessage());
        }
        finally {
            try {
                if (zf != null) {
                    zf.close();
                }
            }
            catch (IOException e2) {
                throw new ZipException(e2.getMessage());
            }
        }
        if (!foundEntry) {
            throw new ZipException("Zip Entry Not found [" + entryName + "]");
        }
        File tmpFile = null;
        ZipOutputStream zos = null;
        try {
            tmpFile = new File(file.getPath() + ".part");
            zos = new ZipOutputStream(new FileOutputStream(tmpFile));
            zf = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (ze.getName().equals(entryName)) continue;
                zos.putNextEntry(ze);
                InputStream is = zf.getInputStream(ze);
                int size = (int)ze.getSize();
                if (size > 0) {
                    int chunk;
                    byte[] bytes = new byte[128];
                    int rb = 0;
                    while ((chunk = is.read(bytes)) > 0) {
                        rb += chunk;
                        zos.write(bytes, 0, chunk);
                    }
                }
                is.close();
                zos.closeEntry();
            }
            zf.close();
            zf = null;
            zos.closeEntry();
            zos.finish();
            zos.close();
            zos = null;
            file.delete();
            tmpFile.renameTo(file);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new ZipException(e.getMessage());
        }
        finally {
            try {
                if (zf != null) {
                    zf.close();
                }
            }
            catch (IOException e2) {
                throw new ZipException(e2.getMessage());
            }
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException e2) {
                throw new ZipException(e2.getMessage());
            }
        }
    }

    public static int putResource(File file, File fileToAdd, String entryName) throws ZipException {
        return ZipUtils.putResource(file, fileToAdd, entryName, null);
    }

    public static int putResource(File file, File fileToAdd, String entryName, IWriteListener writeListener) throws ZipException {
        if (!fileToAdd.exists()) {
            return -1;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileToAdd);
            int n = ZipUtils.putResource(file, entryName, fis, fileToAdd.lastModified(), writeListener);
            return n;
        }
        catch (IOException e) {
            throw new ZipException(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e2) {
                    throw new ZipException(e2.getMessage());
                }
            }
        }
    }
}

