/*
 * Decompiled with CFR 0.152.
 */
package com.bwsw.commitlog;

import com.bwsw.commitlog.CommitLog$;
import com.bwsw.commitlog.CommitLogFlushPolicy;
import com.bwsw.commitlog.filesystem.FilePathManager;
import com.bwsw.commitlog.filesystem.FilePathManager$;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Base64;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rw!B\u0001\u0003\u0011\u0003I\u0011!C\"p[6LG\u000fT8h\u0015\t\u0019A!A\u0005d_6l\u0017\u000e\u001e7pO*\u0011QAB\u0001\u0005E^\u001cxOC\u0001\b\u0003\r\u0019w.\\\u0002\u0001!\tQ1\"D\u0001\u0003\r\u0015a!\u0001#\u0001\u000e\u0005%\u0019u.\\7ji2{wm\u0005\u0002\f\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!F\u0006\u0005\u0002Y\ta\u0001P5oSRtD#A\u0005\t\u000faY!\u0019!C\u00013\u0005aQ\nR\u001bF1R+ejU%P\u001dV\t!\u0004\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005!A.\u00198h\u0015\u0005y\u0012\u0001\u00026bm\u0006L!!\t\u000f\u0003\rM#(/\u001b8h\u0011\u0019\u00193\u0002)A\u00055\u0005iQ\nR\u001bF1R+ejU%P\u001d\u0002Bq!J\u0006\u0012\u0002\u0013\u0005a%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0002O)\u0012\u0001\u0006\u000f\t\u0003SUr!AK\u001a\u000f\u0005-\u0012dB\u0001\u00172\u001d\ti\u0003'D\u0001/\u0015\ty\u0003\"\u0001\u0004=e>|GOP\u0005\u0002\u000f%\u0011QAB\u0005\u0003\u0007\u0011I!\u0001\u000e\u0002\u0002)\r{W.\\5u\u0019><g\t\\;tQB{G.[2z\u0013\t1tGA\u000bJ\u0007>lW.\u001b;M_\u001e4E.^:i!>d\u0017nY=\u000b\u0005Q\u00121&A\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014!C;oG\",7m[3e\u0015\tq\u0004#\u0001\u0006b]:|G/\u0019;j_:L!\u0001Q\u001e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWM\u0002\u0003\r\u0005\u0001\u00115CA!\u000f\u0011!!\u0015I!A!\u0002\u0013)\u0015aB:fG>tGm\u001d\t\u0003\u001f\u0019K!a\u0012\t\u0003\u0007%sG\u000f\u0003\u0005J\u0003\n\u0005\t\u0015!\u0003K\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005-{eB\u0001'N!\ti\u0003#\u0003\u0002O!\u00051\u0001K]3eK\u001aL!!\t)\u000b\u00059\u0003\u0002\u0002\u0003*B\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\rA|G.[2z\u0011\u0015)\u0012\t\"\u0001U)\u0011)fk\u0016-\u0011\u0005)\t\u0005\"\u0002#T\u0001\u0004)\u0005\"B%T\u0001\u0004Q\u0005b\u0002*T!\u0003\u0005\r\u0001\u000b\u0005\b5\u0006\u0013\r\u0011\"\u0003\\\u0003=\u0019XmY8oINLe\u000e^3sm\u0006dW#A#\t\ru\u000b\u0005\u0015!\u0003F\u0003A\u0019XmY8oINLe\u000e^3sm\u0006d\u0007\u0005C\u0004`\u0003\n\u0007I\u0011\u00021\u0002\u001f\u0019LG.\u001a)bi\"l\u0015M\\1hKJ,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I\n\t!BZ5mKNL8\u000f^3n\u0013\t17MA\bGS2,\u0007+\u0019;i\u001b\u0006t\u0017mZ3s\u0011\u0019A\u0017\t)A\u0005C\u0006\u0001b-\u001b7f!\u0006$\b.T1oC\u001e,'\u000f\t\u0005\bU\u0006\u0013\r\u0011\"\u0003l\u00035\u0011\u0017m]37i\u0015s7m\u001c3feV\tA\u000e\u0005\u0002nm:\u0011an\u001d\b\u0003_Ft!!\f9\n\u0003}I!A\u001d\u0010\u0002\tU$\u0018\u000e\\\u0005\u0003iV\faAQ1tKZ\"$B\u0001:\u001f\u0013\t9\bPA\u0004F]\u000e|G-\u001a:\u000b\u0005Q,\bB\u0002>BA\u0003%A.\u0001\bcCN,g\u0007N#oG>$WM\u001d\u0011\t\u000fq\f%\u0019!C\u0005{\u0006\u0019Q\u000eZ\u001b\u0016\u0003y\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004y\t\u0001b]3dkJLG/_\u0005\u0005\u0003\u000f\t\tAA\u0007NKN\u001c\u0018mZ3ES\u001e,7\u000f\u001e\u0005\b\u0003\u0017\t\u0005\u0015!\u0003\u007f\u0003\u0011iG-\u000e\u0011\t\u0013\u0005=\u0011I1A\u0005\n\u0005E\u0011!\u00033fY&l\u0017\u000e^3s+\t\t\u0019\u0002E\u0002\u0010\u0003+I1!a\u0006\u0011\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005m\u0011\t)A\u0005\u0003'\t!\u0002Z3mS6LG/\u001a:!\u0011%\ty\"\u0011a\u0001\n\u0013\t\t#\u0001\tgS2,7I]3bi&|g\u000eV5nKV\u0011\u00111\u0005\t\u0004\u001f\u0005\u0015\u0012bAA\u0014!\t!Aj\u001c8h\u0011%\tY#\u0011a\u0001\n\u0013\ti#\u0001\u000bgS2,7I]3bi&|g\u000eV5nK~#S-\u001d\u000b\u0005\u0003_\t)\u0004E\u0002\u0010\u0003cI1!a\r\u0011\u0005\u0011)f.\u001b;\t\u0015\u0005]\u0012\u0011FA\u0001\u0002\u0004\t\u0019#A\u0002yIEB\u0001\"a\u000fBA\u0003&\u00111E\u0001\u0012M&dWm\u0011:fCRLwN\u001c+j[\u0016\u0004\u0003bCA \u0003\u0002\u0007\t\u0019!C\u0005\u0003\u0003\nAb\\;uaV$8\u000b\u001e:fC6,\"!a\u0011\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013\u001f\u0003\tIw.\u0003\u0003\u0002N\u0005\u001d#\u0001\u0006\"vM\u001a,'/\u001a3PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0006\u0002R\u0005\u0003\r\u00111A\u0005\n\u0005M\u0013\u0001E8viB,Ho\u0015;sK\u0006lw\fJ3r)\u0011\ty#!\u0016\t\u0015\u0005]\u0012qJA\u0001\u0002\u0004\t\u0019\u0005\u0003\u0005\u0002Z\u0005\u0003\u000b\u0015BA\"\u00035yW\u000f\u001e9viN#(/Z1nA!A\u0011QL!A\u0002\u0013%1,A\bdQVt7n\u0016:ji\u0016\u001cu.\u001e8u\u0011%\t\t'\u0011a\u0001\n\u0013\t\u0019'A\ndQVt7n\u0016:ji\u0016\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u00020\u0005\u0015\u0004\"CA\u001c\u0003?\n\t\u00111\u0001F\u0011\u001d\tI'\u0011Q!\n\u0015\u000b\u0001c\u00195v].<&/\u001b;f\u0007>,h\u000e\u001e\u0011\t\u0013\u00055\u0014\t1A\u0005\n\u0005\u0005\u0012!D2ik:\\w\n]3o)&lW\rC\u0005\u0002r\u0005\u0003\r\u0011\"\u0003\u0002t\u0005\t2\r[;oW>\u0003XM\u001c+j[\u0016|F%Z9\u0015\t\u0005=\u0012Q\u000f\u0005\u000b\u0003o\ty'!AA\u0002\u0005\r\u0002\u0002CA=\u0003\u0002\u0006K!a\t\u0002\u001d\rDWO\\6Pa\u0016tG+[7fA!9\u0011QP!\u0005\u0002\u0005}\u0014A\u00029viJ+7\rF\u0004K\u0003\u0003\u000bY)a$\t\u0011\u0005\r\u00151\u0010a\u0001\u0003\u000b\u000bq!\\3tg\u0006<W\rE\u0003\u0010\u0003\u000f\u000b\u0019\"C\u0002\u0002\nB\u0011Q!\u0011:sCfD\u0001\"!$\u0002|\u0001\u0007\u00111C\u0001\f[\u0016\u001c8/Y4f)f\u0004X\r\u0003\u0006\u0002\u0012\u0006m\u0004\u0013!a\u0001\u0003'\u000b\u0001b\u001d;beRtUm\u001e\t\u0004\u001f\u0005U\u0015bAAL!\t9!i\\8mK\u0006t\u0007bBAN\u0003\u0012\u0005\u0011QT\u0001\u0006G2|7/\u001a\u000b\u0003\u0003_Aq!!)B\t\u0013\ti*A\u0006gYV\u001c\bn\u0015;sK\u0006l\u0007bBAS\u0003\u0012%\u0011QT\u0001\u000ee\u0016\u001cX\r^\"pk:$XM]:\t\u000f\u0005%\u0016\t\"\u0003\u0002,\u0006Aa-\u001b:tiJ+h\u000e\u0006\u0002\u0002\u0014\"9\u0011qV!\u0005\n\u0005u\u0015\u0001C<sSR,W\nR\u001b\t\u000f\u0005M\u0016\t\"\u0003\u00026\u0006qq-\u001a;DkJ\u0014XM\u001c;TK\u000e\u001cHCAA\u0012\u0011\u001d\tI,\u0011C\u0005\u0003W\u000bA\u0002^5nK\u0016C8-Z3eK\u0012D\u0011\"!0B#\u0003%\t!a0\u0002!A,HOU3dI\u0011,g-Y;mi\u0012\u001aTCAAaU\r\t\u0019\n\u000f")
public class CommitLog {
    private final CommitLogFlushPolicy.ICommitLogFlushPolicy policy;
    private final int secondsInterval;
    private final FilePathManager com$bwsw$commitlog$CommitLog$$filePathManager;
    private final Base64.Encoder base64Encoder;
    private final MessageDigest md5;
    private final byte delimiter;
    private long fileCreationTime;
    private BufferedOutputStream outputStream;
    private int chunkWriteCount;
    private long chunkOpenTime;

    public static CommitLogFlushPolicy.ICommitLogFlushPolicy $lessinit$greater$default$3() {
        return CommitLog$.MODULE$.$lessinit$greater$default$3();
    }

    public static String MD5EXTENSION() {
        return CommitLog$.MODULE$.MD5EXTENSION();
    }

    private int secondsInterval() {
        return this.secondsInterval;
    }

    public FilePathManager com$bwsw$commitlog$CommitLog$$filePathManager() {
        return this.com$bwsw$commitlog$CommitLog$$filePathManager;
    }

    private Base64.Encoder base64Encoder() {
        return this.base64Encoder;
    }

    private MessageDigest md5() {
        return this.md5;
    }

    private byte delimiter() {
        return this.delimiter;
    }

    private long fileCreationTime() {
        return this.fileCreationTime;
    }

    private void fileCreationTime_$eq(long x$1) {
        this.fileCreationTime = x$1;
    }

    private BufferedOutputStream outputStream() {
        return this.outputStream;
    }

    private void outputStream_$eq(BufferedOutputStream x$1) {
        this.outputStream = x$1;
    }

    private int chunkWriteCount() {
        return this.chunkWriteCount;
    }

    private void chunkWriteCount_$eq(int x$1) {
        this.chunkWriteCount = x$1;
    }

    private long chunkOpenTime() {
        return this.chunkOpenTime;
    }

    private void chunkOpenTime_$eq(long x$1) {
        this.chunkOpenTime = x$1;
    }

    public String putRec(byte[] message, byte messageType, boolean startNew) {
        CommitLogFlushPolicy.OnCountInterval onCountInterval;
        CommitLogFlushPolicy.OnTimeInterval onTimeInterval;
        Object object;
        if (startNew && !this.firstRun()) {
            this.resetCounters();
            this.outputStream().close();
            this.writeMD5();
            object = this.com$bwsw$commitlog$CommitLog$$filePathManager().getNextPath();
        } else {
            object = BoxedUnit.UNIT;
        }
        if (this.firstRun() || this.timeExceeded()) {
            if (!this.firstRun()) {
                this.resetCounters();
                this.outputStream().close();
                this.writeMD5();
            }
            this.com$bwsw$commitlog$CommitLog$$filePathManager().getNextPath();
            this.fileCreationTime_$eq(this.getCurrentSecs());
            this.outputStream_$eq(new BufferedOutputStream(new FileOutputStream(this.com$bwsw$commitlog$CommitLog$$filePathManager().getCurrentPath() + FilePathManager$.MODULE$.EXTENSION(), true)));
        }
        long now = System.currentTimeMillis();
        CommitLogFlushPolicy.ICommitLogFlushPolicy iCommitLogFlushPolicy = this.policy;
        if (iCommitLogFlushPolicy instanceof CommitLogFlushPolicy.OnTimeInterval && (long)(Predef$.MODULE$.Integer2int((onTimeInterval = (CommitLogFlushPolicy.OnTimeInterval)iCommitLogFlushPolicy).seconds()) * 1000) + this.chunkOpenTime() < now) {
            this.chunkOpenTime_$eq(now);
            this.flushStream();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (iCommitLogFlushPolicy instanceof CommitLogFlushPolicy.OnCountInterval && BoxesRunTime.equalsNumObject((Number)(onCountInterval = (CommitLogFlushPolicy.OnCountInterval)iCommitLogFlushPolicy).count(), (Object)BoxesRunTime.boxToInteger((int)this.chunkWriteCount()))) {
            this.chunkWriteCount_$eq(0);
            this.flushStream();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        byte[] encodedMsgWithType = this.base64Encoder().encode((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{messageType}), ClassTag$.MODULE$.Byte()))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(message)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
        package$.MODULE$.Stream().continually((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.outputStream().write((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{this.delimiter()}), ClassTag$.MODULE$.Byte()))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(encodedMsgWithType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))));
        this.chunkWriteCount_$eq(this.chunkWriteCount() + 1);
        this.md5().update((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{this.delimiter()}), ClassTag$.MODULE$.Byte()));
        this.md5().update(encodedMsgWithType);
        return this.com$bwsw$commitlog$CommitLog$$filePathManager().getCurrentPath() + FilePathManager$.MODULE$.EXTENSION();
    }

    public boolean putRec$default$3() {
        return false;
    }

    public void close() {
        block0: {
            if (this.firstRun()) break block0;
            this.resetCounters();
            this.outputStream().close();
            this.writeMD5();
        }
    }

    private void flushStream() {
        this.outputStream().flush();
    }

    private void resetCounters() {
        this.fileCreationTime_$eq(-1L);
        this.chunkWriteCount_$eq(0);
        this.chunkOpenTime_$eq(System.currentTimeMillis());
    }

    private boolean firstRun() {
        return this.fileCreationTime() == -1L;
    }

    private void writeMD5() {
        String fileMD5 = new BigInteger(1, this.md5().digest()).toString(16);
        new PrintWriter(this, fileMD5){
            {
                this.write(fileMD5$1);
                this.close();
            }
        };
        this.md5().reset();
    }

    private long getCurrentSecs() {
        return System.currentTimeMillis() / 1000L;
    }

    private boolean timeExceeded() {
        return this.getCurrentSecs() - this.fileCreationTime() >= (long)this.secondsInterval();
    }

    public CommitLog(int seconds, String path, CommitLogFlushPolicy.ICommitLogFlushPolicy policy) {
        this.policy = policy;
        Predef$.MODULE$.require(seconds > 0, (Function0 & Serializable & scala.Serializable)() -> "Seconds cannot be less than 1");
        this.secondsInterval = seconds;
        this.com$bwsw$commitlog$CommitLog$$filePathManager = new FilePathManager(path);
        this.base64Encoder = Base64.getEncoder();
        this.md5 = MessageDigest.getInstance("MD5");
        this.delimiter = 0;
        this.fileCreationTime = -1L;
        this.chunkWriteCount = 0;
        this.chunkOpenTime = 0L;
    }
}

