/*
 * Decompiled with CFR 0.152.
 */
package com.bwsw.commitlog.filesystem;

import com.bwsw.commitlog.filesystem.CommitLogFileIterator;
import com.bwsw.commitlog.utils.Utils$;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001\u0017\ti1i\\7nSRdun\u001a$jY\u0016T!a\u0001\u0003\u0002\u0015\u0019LG.Z:zgR,WN\u0003\u0002\u0006\r\u0005I1m\\7nSRdwn\u001a\u0006\u0003\u000f!\tAAY<to*\t\u0011\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0005a\u0006$\b\u000e\u0005\u0002\u001699\u0011aC\u0007\t\u0003/9i\u0011\u0001\u0007\u0006\u00033)\ta\u0001\u0010:p_Rt\u0014BA\u000e\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011QD\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mq\u0001\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\b\u0006\u0002#IA\u00111\u0005A\u0007\u0002\u0005!)1c\ba\u0001)!9a\u0005\u0001b\u0001\n\u00139\u0013\u0001\u00024jY\u0016,\u0012\u0001\u000b\t\u0003S9j\u0011A\u000b\u0006\u0003W1\n!![8\u000b\u00035\nAA[1wC&\u0011qF\u000b\u0002\u0005\r&dW\r\u0003\u00042\u0001\u0001\u0006I\u0001K\u0001\u0006M&dW\r\t\u0005\bg\u0001\u0011\r\u0011\"\u0003(\u0003\u001diG-\u000e$jY\u0016Da!\u000e\u0001!\u0002\u0013A\u0013\u0001C7ek\u0019KG.\u001a\u0011\t\u000f]\u0002\u0001\u0019!C\u0005q\u0005\u0019Q\u000eZ\u001b\u0016\u0003e\u00022!\u0004\u001e\u0015\u0013\tYdB\u0001\u0004PaRLwN\u001c\u0005\b{\u0001\u0001\r\u0011\"\u0003?\u0003\u001diG-N0%KF$\"a\u0010\"\u0011\u00055\u0001\u0015BA!\u000f\u0005\u0011)f.\u001b;\t\u000f\rc\u0014\u0011!a\u0001s\u0005\u0019\u0001\u0010J\u0019\t\r\u0015\u0003\u0001\u0015)\u0003:\u0003\u0011iG-\u000e\u0011\t\u000b\u001d\u0003A\u0011\u0001%\u0002\u000f\u001d,GOR5mKR\t\u0001\u0006C\u0003K\u0001\u0011\u00051*A\u0006hKRLE/\u001a:bi>\u0014H#\u0001'\u0011\u0005\rj\u0015B\u0001(\u0003\u0005U\u0019u.\\7ji2{wMR5mK&#XM]1u_JDQ\u0001\u0015\u0001\u0005\u0002E\u000bAbY1mGVd\u0017\r^3N\tV\"\u0012\u0001\u0006\u0005\u0006'\u0002!\t!U\u0001\u0007O\u0016$X\nR\u001b\t\u000bU\u0003A\u0011\u0001,\u0002\u0011\rDWmY6N\tV\"\u0012a\u0016\t\u0003\u001baK!!\u0017\b\u0003\u000f\t{w\u000e\\3b]\")1\f\u0001C\u0001-\u0006IQ\u000eZ\u001bFq&\u001cHo\u001d")
public class CommitLogFile {
    private final String path;
    private final File file;
    private final File md5File;
    private Option<String> md5;

    private File file() {
        return this.file;
    }

    private File md5File() {
        return this.md5File;
    }

    private Option<String> md5() {
        return this.md5;
    }

    private void md5_$eq(Option<String> x$1) {
        this.md5 = x$1;
    }

    public File getFile() {
        return this.file();
    }

    public CommitLogFileIterator getIterator() {
        return new CommitLogFileIterator(this.file().toString());
    }

    public String calculateMD5() {
        FileInputStream fileInputStream = new FileInputStream(this.file());
        Stream stream = Utils$.MODULE$.fileContentStream(fileInputStream, 512).takeWhile((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)CommitLogFile.$anonfun$calculateMD5$1(elem)));
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        stream.foreach((Function1 & Serializable & scala.Serializable)elem -> {
            md5.update((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])elem._2())).slice(0, elem._1$mcI$sp()));
            return BoxedUnit.UNIT;
        });
        fileInputStream.close();
        return new BigInteger(1, md5.digest()).toString(16);
    }

    public String getMD5() {
        if (this.md5().isEmpty()) {
            throw new FileNotFoundException("No MD5 file for " + this.path);
        }
        return (String)this.md5().get();
    }

    public boolean checkMD5() {
        String string = this.getMD5();
        String string2 = this.calculateMD5();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean md5Exists() {
        return this.md5().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$calculateMD5$1(Tuple2 elem) {
        return elem._1$mcI$sp() != -1;
    }

    public CommitLogFile(String path) {
        block0: {
            this.path = path;
            this.file = new File(path);
            this.md5File = new File(new StringOps(Predef$.MODULE$.augmentString(this.file().toString())).split('.')[0] + ".md5");
            this.md5 = None$.MODULE$;
            if (!this.md5File().exists()) break block0;
            this.md5_$eq((Option<String>)new Some((Object)Source$.MODULE$.fromFile(this.md5File(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString()));
        }
    }
}

